var canvas = document.getElementById("drawCanvas");
var ctx = canvas.getContext("2d");
ctx.strokeStyle = "#222222";
ctx.lineWith = 2;

// Set up mouse events for drawing
var drawing = false;
var mousePos = { x:0, y:0 };
var lastPos = mousePos;
canvas.addEventListener("mousedown", function (e) {
        drawing = true;
  lastPos = getMousePos(canvas, e);
}, false);
canvas.addEventListener("mouseup", function (e) {
  drawing = false;
}, false);
canvas.addEventListener("mousemove", function (e) {
  mousePos = getMousePos(canvas, e);
}, false);

// Get the position of the mouse relative to the canvas
function getMousePos(canvasDom, mouseEvent) {
  var rect = canvasDom.getBoundingClientRect();
  return {
    x: mouseEvent.clientX - rect.left,
    y: mouseEvent.clientY - rect.top
  };
}

// Get a regular interval for drawing to the screen
window.requestAnimFrame = (function (callback) {
        return window.requestAnimationFrame || 
           window.webkitRequestAnimationFrame ||
           window.mozRequestAnimationFrame ||
           window.oRequestAnimationFrame ||
           window.msRequestAnimaitonFrame ||
           function (callback) {
        window.setTimeout(callback, 1000/60);
           };
})();

// Draw to the canvas
function renderCanvas() {
  if (drawing) {
    ctx.moveTo(lastPos.x, lastPos.y);
    ctx.lineTo(mousePos.x, mousePos.y);
    ctx.stroke();
    lastPos = mousePos;
  }
}

// Allow for animation
(function drawLoop () {
  requestAnimFrame(drawLoop);
  renderCanvas();
})();

// Set up touch events for mobile, etc
canvas.addEventListener("touchstart", function (e) {
        mousePos = getTouchPos(canvas, e);
  var touch = e.touches[0];
  var mouseEvent = new MouseEvent("mousedown", {
    clientX: touch.clientX,
    clientY: touch.clientY
  });
  canvas.dispatchEvent(mouseEvent);
}, false);
canvas.addEventListener("touchend", function (e) {
  var mouseEvent = new MouseEvent("mouseup", {});
  canvas.dispatchEvent(mouseEvent);
}, false);
canvas.addEventListener("touchmove", function (e) {
  var touch = e.touches[0];
  var mouseEvent = new MouseEvent("mousemove", {
    clientX: touch.clientX,
    clientY: touch.clientY
  });
  canvas.dispatchEvent(mouseEvent);
}, false);

// Get the position of a touch relative to the canvas
function getTouchPos(canvasDom, touchEvent) {
  var rect = canvasDom.getBoundingClientRect();
  return {
    x: touchEvent.touches[0].clientX - rect.left,
    y: touchEvent.touches[0].clientY - rect.top
  };
}

// Prevent scrolling when touching the canvas
document.body.addEventListener("touchstart", function (e) {
  if (e.target == canvas) {
    e.preventDefault();
  }
}, false);
document.body.addEventListener("touchend", function (e) {
  if (e.target == canvas) {
    e.preventDefault();
  }
}, false);
document.body.addEventListener("touchmove", function (e) {
  if (e.target == canvas) {
    e.preventDefault();
  }
}, false);


function comma (str) {
    str = String(str);
    return str.replace(/(\d)(?=(?:\d{3})+(?!\d))/g, '$1,');
}
function uncomma(str) {
    str = String(str);
    return str.replace(/[^\d]+/g, '');
}

var signalModal = {
	open: function() {
		$(".signCanverback").fadeIn();
		$(".signCanverWrap").fadeIn();
		$("body").css('overflow','hidden');
	},
	close: function() {
		$(".signCanverback").fadeOut();
		$(".signCanverWrap").fadeOut();
		$("body").css('overflow','scroll');
	},
	submitCanvas: function() {
		var dataUrl = canvas.toDataURL("image/png");

        $("#sig-image").attr("src", dataUrl);
        this.close();
	},
	clearCanvas: function() {
		canvas.width = canvas.width;
	},
	init: function() {
		var oThis = this;
		$(".signCanver").on('click', function() {
			oThis.open();
		});
		$(".signCanverClose").on('click', function() {
			oThis.close();
		});
		$("#sig-submitBtn").on('click', function() {
			oThis.submitCanvas();
		});
		$("#sig-clearBtn").on('click', function() {
			oThis.clearCanvas();
		})
	}
};
signalModal.init();

var estimate = {
	init: function() {
		var oThis = this;

		$(".input-quantity").on('keyup', function() {
			oThis.regInpQuantity($(this)[0]);
		});
		$(".input-quantity").on('focusout', function() {
			oThis.setConsumerPrice($(this));
		});
	},
	regInpQuantity: function($input) {
		var regInt = /^[0-9]+$/;
			
		if (!regInt.test($input.value)) {
            //alert("유효한 숫자가 아닙니다.");
            $input.value = "";
            return false;
        }
	},
	setConsumerPrice: function($input) {
		var $targetRow = $input.closest('tr'),
			quantity = $input[0].value,
			taxExcludePrice = $targetRow.find('.supply-tax-exclude').text(),
			taxIncludePrice = $targetRow.find('.supply-tax-include').text();

		//if (quantity === 0 || quantity === "") return false;
		
		$targetRow.find('.consumer-tax-exclude').text(taxExcludePrice * quantity);
		$targetRow.find('.consumer-tax-include').text(taxIncludePrice * quantity);

		this.setSubTotal($targetRow);
	},
	setSubTotal: function($targetRow) {
		var $subTotalRow = $targetRow.nextAll('.subtotal').first(),
			styleIndex = $subTotalRow.index('.subtotal') + 1,
			tdList = [
				".input-quantity", 
				".supply-tax-exclude", 
				".supply-tax-include", 
				".consumer-tax-exclude", 
				".consumer-tax-include"
			],
			result = null,
			temp = null;

		for (var i in tdList) {
			result = 0;

			$.each($(".style-"+styleIndex), function(idx) {
				if ($(this).find('.input-quantity')[0].value === 0 || $(this).find('.input-quantity')[0].value === "") {
					return;
				}

				if (i == 0) {
					temp = $(this).find(tdList[i])[0].value;
				} else {
					temp = $(this).find(tdList[i]).text();
				}
				result += Number(temp);
			});
			$subTotalRow.find('td').eq(Number(i)+4).text(comma(result));
		}
		this.setTotal();
	},
	setTotal: function() {
		var oThis = this,
			$totalRow = $(".productTable").find(".total"),
			rowIdx = [4, 5, 6, 7, 8],
			tmp = null,
			result = null;

		for (var i in rowIdx) {
			result = 0;
			$.each($(".subtotal"), function() {
				tmp = $(this).find('td').eq(rowIdx[i]).text();
				result += Number(uncomma(tmp));
			});
			$totalRow.find('td').eq(rowIdx[i]).text(comma(result));

			if (rowIdx[i] === 8) {
				$(".totalPrice").children('span').text(comma(result));
			}
		}
	}
};
estimate.init();

var submitContract = {
	init: function() {
		var oThis = this,
			valid = null;
		$(".arrow_right").on('click', function() {
			valid = oThis.validCheck();
			if (!valid) {
				return false;
			}
			oThis.submit();
		});
	},
	validCheck: function() {
		var valid = true;

		if ($("#sig-image").attr("src") === "") {
			alert("서명은 필수 입력 사항입니다.");
			return false;
		}

		$.each($(".input-quantity, .input-option"), function() {
			if ($(this)[0].value === "" || $(this)[0].value === 0) {
				alert("수량은 필수 입력 사항입니다.");
				$(this).focus();
				valid = false;

				return false;
			}
		});
		return valid;
	},
	submit: function() {
		var quantityDict = this.dataToDict(
				$('.productTable').find('tr:gt(1)').not('.subtotal, .total, .opt'), 
				".input-quantity"
			),
			optionDict = this.dataToDict(
				$('.productTable').find('.opt'), 
				".input-option"
			),
			signImage = $("#sig-image").attr("src"),
			specialNote = $("#inp-special-note").val();
		
		$.ajax({
            url: '/order_contract/contract/submit/',
            type: 'POST',
            cache: false,
            data: {
                'order_id': order_id,
                'quantity_dict': JSON.stringify(quantityDict),
                'option_dict': JSON.stringify(optionDict),
                'sign_image': signImage,
                'special_note': specialNote
            },
            async: false,
            success: function (response) {
                if(response.success) {
		            location.href = response.url;
		        }
            }
        });
	},
	dataToDict: function($selector, $inp) {
		return $selector.map(function(i) {
			var row = {};

			$(this).find($inp).each(function (i) {
				var inputId = $(this)[0].name;
				row['input_id'] =  Number(inputId);
				row['quantity'] = Number($(this)[0].value);
			});
			return row;
		}).get();
	}
	
};
submitContract.init();

