function comma (str) {
    str = String(str);
    return str.replace(/(\d)(?=(?:\d{3})+(?!\d))/g, '$1,');
}
function uncomma(str) {
    str = String(str);
    return str.replace(/[^\d]+/g, '');
}
function stringToPrice (str) {
	return parseInt(uncomma(str.split("원")[0]));
}
function priceToString (price) {
	return comma(price) + "원";
}

var estimate = {
	init: function() {
		var oThis = this;
		$.each($(".subtotal"), function() {
			oThis.setSubTotal($(this));
		});
	},
	setSubTotal: function($subTotalRow) {
			var $rowSibling = $("." + $subTotalRow.prev('tr')[0].className),
			tdList = [
				".quantity", 
				".supply-tax-exclude", 
				".supply-tax-include", 
				".consumer-tax-exclude", 
				".consumer-tax-include"
			],
			result = null,
			temp = null;

		for (var i in tdList) {
			result = 0;

			$.each($rowSibling, function(idx) {
				if (i == 0) {
					temp = $(this).find(tdList[i]).text().split("개")[0];
				} else {
					temp = stringToPrice($(this).find(tdList[i]).text());
				}
				result += Number(temp);
			});
			if (i == 0) {
				$subTotalRow.find('td').eq(Number(i)+4).text(result + "개");
			} else {
				$subTotalRow.find('td').eq(Number(i)+4).text(priceToString(result));
			}
		}
		this.setTotal();
	},
	setTotal: function() {
		var oThis = this,
			$totalRow = $(".productTable").find(".total"),
			rowIdx = [4, 5, 6, 7, 8],
			tmp = null,
			result = null;

		for (var i in rowIdx) {
			result = 0;
			$.each($(".subtotal"), function() {
				tmp = $(this).find('td').eq(rowIdx[i]).text();
				result += Number(uncomma(tmp));
			});

			if (rowIdx[i] === 4) {
				$totalRow.find('td').eq(rowIdx[i]).text(result + "개");
			} else {
				$totalRow.find('td').eq(rowIdx[i]).text(priceToString(result));
			}

			if (rowIdx[i] === 8) {
				$(".totalPrice").children('span').text(priceToString(result));
			}
		}
	}
};
estimate.init();

function makePdf() {
	var pdfFile,
    	$elements = $('.contract'),
        content = [],
        count = 0;
        docDefinition = {content: content};

    for (i = $elements.length - 1; i >= 0; i--) {
        makeCanvas(i); 
    } 

    function makeCanvas(idx) {
        count += 1;
        html2canvas($elements[idx], {
            onrendered: function(canvas) {
                var data = canvas.toDataURL();
                content[idx] = {
                    image:data, 
                    width:430,
                    margin: [40,0]
                };
                count -= 1;
                if (count === 0) {
                    pdfMake.createPdf(docDefinition).getDataUrl(function(dataUrl) {
                        var pdfFile = dataUrl;
                        $.ajax({
                            type: 'POST',
                            url: '/order_contract/contract/pdf/save/',
                            data: {
                                'order_id': order_id,
                                'pdf_file': pdfFile
                            },
                            async: false,
                            success: function() {
                            	
                            }
                        }); 
                    });
                }
            }
        })
    }
}

$(document).ready(function() {
	makePdf();
});


