/* 코디하는 모달창을 제외한 부분의 동작기능을 담당하는 곳 */

$(document).ready(function () {

    if(sc.season === ""){
        sc.season = "winter";
    }

    if(sc.style === ""){
        sc.style = "formal";
    }

    if (sc.ebookCatalogCoupleIndex != 0){
        sc.seasonTypeClickEvent(sc.season);
        sc.styleTypeClickEvent(sc.style);
        $("li[rel='tab2']").click();
    }else{
        sc.centerListChange();
    }

    sc.jacketHideCheck();

});


//슬라이드 내에 선택된 커플의 id 값을 가져온다
sc.getSelectedCoupleIndex = function() {
    return $('.swiper-slide-active').children().first().val();
};

// 슬라이드 or 한커플 보기 기능 custom_admin_mapping.js 에서 슬라이드 클릭부분시 발생
sc.isSlideChange = function(isSlide) {
    if(isSlide){
        sc.isSlide = true;
        $('#center_list').show();
        $('.model-container').hide();
    }else {
        sc.isSlide = false;
        $('#center_list').hide();
        $('.model-container').show();
        sc.slideJacketAndBackVisibleEvent();
    }
};

// 동복하복 선택된 값을 전역변수에 담고 슬라이드 html 조각 리턴
sc.seasonChange = function(season) {
    if (sc.season != season) {
        sc.season = season;
        sc.centerListChange();
        // sc.leftListChange();
        sc.jacketHideCheck();
    }
};

// 정복 트레이닝 선택된 값을 전역변수에 담고 슬라이드 html 조각 리턴
sc.styleChange = function(style) {
    if (sc.style != style) {
        sc.style = style;
        sc.centerListChange();
        // sc.leftListChange();
        sc.jacketHideCheck();
    }
};

//인기제품, 카탈로그, 미공개코디 선택된 값을 전역변수에 담고 슬라이드 html 조각 리턴
sc.coupleCategoryChange = function(coupleCategory) {
    if (sc.coupleCategory != coupleCategory){
        sc.coupleCategory = coupleCategory;
        sc.centerListChange();
        // sc.leftListChange();
    }
};

//슬라이드 리스트 출력  리로드 하는 함수
sc.centerListChange = function() {

    // 가운데 이미지가 리로드되면 자동으로 슬라이드모드로 변경된다
    sc.isSlideChange(true);
    $("#slideViewBtn").click();

    $.ajax({
        url: '/simulation/custom_admin/center_list_change',
        data: {
          season: sc.season,
          style: sc.style,
          couple_category: sc.coupleCategory,
          final_fitting_id: sc.finalFittingIndex
        },
        success: function(data) {

            $('#center_list').html(data);

            // 왼쪽 메뉴도 다시 리로드 해주고 슬라이더 동작도 적용시켜 준다.
            sc.leftListChange();
            sc.swiperSlideReLoad();

            //리로드된 놈들은 기존의 이벤트를 인식하지 못한다 그래서 다시한번 호출해줌
            // StarClick();//이거 안하면 별 클릭해도 안바뀜

            // 슬라이드 리스트에서 active 된 애들만 보여준다
            sc.starAndDeleteBtnVisibleEvent();

            // 사용자 모드일땐 bottom에 저장목록도 리로드 해준다
            var simType = $("#simType").val();
            if (simType === "normal"){
                sc.favoriteCoupleList();
            }
        },
        error: function() {
            console.log('error');
        }
    });
};

//왼쪽 리스트 체인지 함수
sc.leftListChange = function () {

    $.ajax({
        url: '/simulation/custom_admin/left_list_change',
        data: {
          season: sc.season,
          style: sc.style,
          couple_category: sc.coupleCategory,
        },
        success: function(data) {

            if (sc.coupleCategory == "popular"){
                $("#leftPopularCouple").html(data);
            } else if (sc.coupleCategory == "catalog") {
                $("#leftCatalogCouple").html(data);

                //ebook 카탈로그에서 클릭해서 넘어온것이라면 해당하는 슬라이드로 이동
                // 이후 카탈로그 탭 클릭할때마다 슬라이드 되지 않게 인덱스 초기화
                if(sc.ebookCatalogCoupleIndex != 0){
                    $("#coupleIndex" + sc.ebookCatalogCoupleIndex).click();
                    sc.ebookCatalogCoupleIndex = 0;
                }

            } else {
                $("#leftNormalCouple").html(data);
            }

            // $('#center_list').html(data);
        },
        error: function() {
            console.log('error');
        }
    });

};


//슬라이더 리로드 함수 smart의 비동기작업은 html 조각을 리로드해야해서
// 슬라이드내용이 리로드되면 슬라이드도 다시 리로드해줘야한다
sc.swiperSlideReLoad = function () {

    //리로드 될때마다  이전에 선언한 sc.swiper를 지우고 선언하는것을 반복한다 리로드가 이게 짜증남
    if (sc.swiper){
        sc.swiper.destroy();
    }
    sc.swiper = new Swiper('.swiper-container', {
        pagination: '.swiper-pagination',
        slidesPerView: 4,
        centeredSlides: true,
        paginationClickable: true,
        spaceBetween: 30,
        grabCursor: true,
        loop: false,
        onSlideChangeStart: function () {
            sc.slideJacketAndBackVisibleEvent();
            sc.starAndDeleteBtnVisibleEvent();
        }
    });

};

// 시즌이나 스타일 변경시 자켓 토글버튼 숨기는 기능
sc.jacketHideCheck = function () {
    if((sc.season == "winter")&&(sc.style == "formal") ){
        $(".jacketOnOff").show();
    }else{
        $(".jacketOnOff").hide();
    }
};


// 슬라이드 부분 뒷모습보기 버튼 클릭 이벤트
sc.slideBackClick = function () {
    if(sc.isSlideBack){
        sc.isSlideBack = false;
    }else {
        sc.isSlideBack = true;
    }
    sc.slideJacketAndBackVisibleEvent();
};

// 슬라이드 부분 자켓 버튼 클릭 이벤트
sc.slideJacketHideClickEvent = function () {
    if(sc.isSlideJacketOff){
        sc.isSlideJacketOff = false;
        $("#slideJacketToggleCheck").prop("checked", true);
    }else {
        sc.isSlideJacketOff = true;
        $("#slideJacketToggleCheck").prop("checked", false);
    }
    sc.slideJacketAndBackVisibleEvent();
};


// 슬라이드 부분 자켓 뒷모습 판별 후 show hide
sc.slideJacketAndBackVisibleEvent = function () {

    var currentCoupleIndex = sc.getSelectedCoupleIndex();
    $.ajax({
        url: '/simulation/custom_admin/change_slide_back_jacket',
        data: {
            couple_id: currentCoupleIndex,
            is_back: sc.isSlideBack,
            is_jacket_off: sc.isSlideJacketOff
        },
        dataType: 'json',
        success: function(data) {
            $('.swiper-slide-active').find('.boy_fitting').attr('src', data.boyFittingUrl);
            $('.swiper-slide-active').find('.girl_fitting').attr('src', data.girlFittingUrl);
            $('#boyOneViewFitting').attr('src', data.boyFittingUrl);
            $('#girlOneViewFitting').attr('src', data.girlFittingUrl);
        },
        error: function() {
            console.log('error');
        }
    });


};

// 현재 커플들만 위에 즐겨찾기랑 삭제 아이콘 보여줌
sc.starAndDeleteBtnVisibleEvent = function () {
    $(".modelbtn").hide();
    $(".swiper-slide-active .modelbtn").show();
};

// left에 커플 클릭이벤트 그에 해당하는 index로 슬라이드 이동시켜줌
sc.slideToEvent = function (index) {
    sc.swiper.slideTo(index);
};


// 커플 삭제 이벤트
sc.coupleDelete = function (coupleIndex) {

    $.confirm({
        title: 'Confirm!',
        content: '정말 삭제하시겠습니까? 폴더내에 저장된 이미지도 같이 삭제됩니다.',
        useBootstrap: false,
        buttons: {
            confirm: function () {

                $.ajax({
                    url: '/simulation/custom_admin/couple_delete',
                    dataType: 'json',
                    data: {
                      couple_id: coupleIndex
                    },
                    success: function(data) {
                        $.alert({title: 'Alert!', content: data.msg, useBootstrap: false});
                        sc.centerListChange();

                    },
                    error: function() {
                        alert('error');
                    }
                });

            },
            cancel: function () {
            }
        }
    });

};


// 슬라이드에서 클릭했을때 커플 상세화면
// 슬라이드내에서 active된 커플의 아이디를 가지고 sc.coupleDetail() 호출
sc.slideCoupleDetailClickEvent = function () {
    var currentCoupleIndex = sc.getSelectedCoupleIndex();
    sc.coupleDetail(currentCoupleIndex);
};


// 커플 상세보기
sc.coupleDetail = function (currentCoupleIndex) {
    $(".ModelInformation").fadeIn();
    // var currentCoupleIndex = sc.getSelectedCoupleIndex();

    $.ajax({
        url: '/simulation/custom_admin/couple_detail',
        data: {
          couple_id: currentCoupleIndex
        },
        success: function(data) {
            $("#coupleDetail").html(data);
        },
        error: function() {
            console.log('error');
        }
    });

};

//상세보기 닫기버튼 클릭시
sc.coupleDetailCloseEvent = function () {
    $(".ModelInformation").fadeOut();
};


// 동복하복 클릭시
sc.seasonTypeClickEvent = function (season) {

    sc.seasonChange(season);

    var seasonWinterBtn= $("#seasonWinterBtn");
    var seasonSummerBtn= $("#seasonSummerBtn");

    if(season == 'winter'){
        seasonWinterBtn.find("img").attr("src", seasonWinterBtn.find('img').attr('src').replace('_b.png','_c.png'));
        seasonSummerBtn.find("img").attr("src", seasonSummerBtn.find('img').attr('src').replace('_c.png','_b.png'));
    }else{
        seasonWinterBtn.find("img").attr("src", seasonWinterBtn.find('img').attr('src').replace('_c.png','_b.png'));
        seasonSummerBtn.find("img").attr("src", seasonSummerBtn.find('img').attr('src').replace('_b.png','_c.png'));
    }

};


//정복 트레이닝 클릭시
sc.styleTypeClickEvent = function (style) {

    sc.styleChange(style);

    var styleFormalBtn= $("#styleFormalBtn");
    var styleTrainingBtn= $("#styleTrainingBtn");

    if(style == 'formal'){
        styleFormalBtn.find("img").attr("src", styleFormalBtn.find('img').attr('src').replace('_b.png','_c.png'));
        styleTrainingBtn.find("img").attr("src", styleTrainingBtn.find('img').attr('src').replace('_c.png','_b.png'));
    }else{
        styleFormalBtn.find("img").attr("src", styleFormalBtn.find('img').attr('src').replace('_c.png','_b.png'));
        styleTrainingBtn.find("img").attr("src", styleTrainingBtn.find('img').attr('src').replace('_b.png','_c.png'));
    }

};


// 슬라이드 검색이벤트
// 혹시라도 나중에 카테고리 구분없이 검색해주세요~라는 같은소리를 한다면 카테고리 클릭 이벤트 지정후 슬라이드 이동해야한다
sc.slideSearchEvent = function () {

    if(sc.coupleCategory !== "catalog"){
        $.alert({title: "Alert!", content: "카탈로그에서만 검색이 가능합니다.", useBootstrap: false});
        return false;
    }

    var searchComplete = false;
    var searchWord = $("#slideSearch").val();

    $(".slideCoupleName").each(function () {
        if($(this).val().toLowerCase() === searchWord.toLowerCase()){
            searchComplete = true;
            $(this).parent().click();
        }
    });

    if (!(searchComplete)){
        $.alert({title: "Alert!", content: "검색 결과가 없습니다.", useBootstrap: false});
    }

};


// 검색버튼 말고 엔터 눌렀을때
sc.slideSearchEnterCheck = function () {
    if(event.keyCode == 13){
        sc.slideSearchEvent();
    }
};