# -*- coding: utf-8 -*-
import urllib

from django.template import RequestContext
from django.shortcuts import render_to_response
from django.contrib.auth.models import User, Permission
from django.http import HttpResponseRedirect, HttpResponse, Http404
from django.views.decorators.csrf import csrf_exempt
from django.contrib.auth.decorators import login_required, user_passes_test
from django.core.exceptions import ObjectDoesNotExist
from cStringIO import StringIO
from django.core.files.base import ContentFile
from django.db.models import Q
from django.db.models import Max, Min
from django.core.files import File
from users.models import *
from fabric.models import *
from product.models import *
from PIL import Image
from common.common import *
from common.image import handleUploadedImg
from common.exception import UploadedImgFileError
from users.user_check import admin_check
from simulation.views import runSimulation
from django.db import transaction

import json
import os
import math
import settings
import string
import random
import imghdr

## get FabricCategoty list
# Return: xml - FabricCategory list
def getFabricCategoryList(request):
	if request.user.is_anonymous():
		variables = {'categoryList': '', 'type': '', 'level': ''}
		return render_to_response('xml/categorylist.xml', RequestContext(request, variables))
	else:
		type = int(request.POST['Type']) if request.POST.has_key('Type') else 2
		valid = request.POST['Visible'].lower() == 'true' if request.POST.has_key('Visible') else True
		level = request.POST.get('level', 0)
		supercid = request.POST.get('supercid', '')
		'''
		if level == '1':
			categoryList = FabricCategory.objects.filter(valid = valid, level = level)
		else:
			supercategory = FabricCategory.objects.get(id = supercid)
			categoryList = FabricCategory.objects.filter(valid = valid, level = level, supercategory = supercategory)
		'''
		# 2019.6.11 후조밍저용 Manager  Fabric 카테고리 분류
		if level == '1':
			if request.user.is_superuser:
				categoryList = FabricCategory.objects.filter(valid = valid, level = level)
			else:
				categoryList = FabricCategory.objects.filter(id=request.user.userprofile.userCategory.id, valid=valid, level=level)
			variables = {'categoryList': categoryList, 'type': type, 'level': level, 'count': None}
		elif level == '2':
			supercategory = FabricCategory.objects.get(id=supercid)
			selectUser = UserProfile.objects.get(userCategory=supercategory)
			fabricCount = Fabric.objects.filter(user=selectUser, category__isnull=False).count()
			print "fabricCount"
			print fabricCount
			categoryList = FabricCategory.objects.filter(valid=valid, level=level, supercategory=supercategory)
			variables = {'categoryList': categoryList, 'type': type, 'level': level, 'count': fabricCount}
			
		else:
			supercategory = FabricCategory.objects.get(id = supercid)
			categoryList = FabricCategory.objects.filter(valid = valid, level = level, supercategory = supercategory)
			variables = {'categoryList': categoryList, 'type': type, 'level': level, 'count': None}

		return render_to_response('xml/categorylist.xml', RequestContext(request, variables))

## create FabricCategory
# Return: json - {success: True/False, [id: <created_category_id>]}
def createFabricCategory(request):
	try:
		name = request.POST['name']
		level = request.POST['level']
		supercid = request.POST.get('supercid', '')
	except:
		raise Http404
	try:
		orderValue = FabricCategory.objects.filter(valid = True, level = level).latest().orderValue + 1
	except ObjectDoesNotExist:
		orderValue = 0
	
	# check duplicated name
	if supercid == '':
		category = FabricCategory(name = name, orderValue = orderValue, level = level)
	else:
		supercategory = FabricCategory.objects.get(id = supercid)
		if FabricCategory.objects.filter(name = name, level = level, supercategory = supercategory).exists():
			variables = {'success': False, 'reason': 'NameAlreadyExists'}
			return HttpResponse(json.dumps(variables), mimetype='application/json')
		category = FabricCategory(name = name, orderValue = orderValue, level = level, supercategory = supercategory)
	category.save()

	variables = {'success': True, 'id': category.id}
	return HttpResponse(json.dumps(variables), mimetype='application/json')

## modify FabricCategory name
# Return: json - {success: True/False}
def modifyFabricCategory(request):
	try:
		categoryId = int(request.POST['cid'])
		new_name = request.POST['name']
	except:
		raise Http404
	
	try:
		category = FabricCategory.objects.get(id = categoryId)
	except ObjectDoesNotExist:
		variables = {'success': False, 'reason': 'DoesNotExist'}
		return HttpResponse(json.dumps(variables), mimetype='application/json')
	
	# check duplicated name
	
	if category.level > 1:
		supercategory = category.supercategory
		if FabricCategory.objects.filter(valid = True, name = new_name, supercategory=supercategory).exists():
			variables = {'success': False, 'reason': 'NameAlreadyExists'}
			return HttpResponse(json.dumps(variables), mimetype='application/json')
	else:
		if FabricCategory.objects.filter(valid = True, name = new_name).exists():
			variables = {'success': False, 'reason': 'NameAlreadyExists'}
			return HttpResponse(json.dumps(variables), mimetype='application/json')
	category.name = new_name
	category.save()
	
	variables = {'success': True}
	return HttpResponse(json.dumps(variables), mimetype='application/json')

## delete FabricCategory
# Return: json - {success: True/False}
def deleteFabricCategory(request):
	try:
		categoryId = int(request.POST['cid'])
	except:
		raise Http404
	
	try:
		category = FabricCategory.objects.get(id = categoryId)
	except ObjectDoesNotExist:
		variables = {'success': False, 'reason': 'DoesNotExist'}
		return HttpResponse(json.dumps(variables), mimetype='application/json')
	
	category.delete()
	
	variables = {'success': True}
	return HttpResponse(json.dumps(variables), mimetype='application/json')

## switch two FabricCategory orderValue
# Return: json - {success: True/False}
def switchFabricCategoryOrder(request):
	try:
		srcCategoryId = int(request.POST['scid'])
		dstCategoryId = int(request.POST['dcid'])
	except:
		raise Http404
	
	try:
		srcCategory = FabricCategory.objects.get(id = srcCategoryId)
		dstCategory = FabricCategory.objects.get(id = dstCategoryId)
	except ObjectDoesNotExist:
		raise Http404
	'''
	if abs(srcCategory.orderValue - dstCategory.orderValue) != 1:
		raise Http404
	'''
	(srcCategory.orderValue, dstCategory.orderValue) = (dstCategory.orderValue, srcCategory.orderValue)
	srcCategory.save()
	dstCategory.save()
	
	variables = {'success': True}
	return HttpResponse(json.dumps(variables), mimetype='application/json')

@csrf_exempt
def getBelongs(request):
	try:
		layerName = request.POST['layerName']
		pid = request.POST['pid']
		type = request.POST['type']
	except:
		raise Http404	
	belongList = BelongingToProduct.objects.filter(product__id=pid, layerName=layerName).order_by('id')
	if type == 'json':
		idList = []
		for belong in belongList:
			idList.append(belong.fabric.id)
		variables = {'idList': idList}	
		return HttpResponse(json.dumps(variables), mimetype='application/json')
	elif type == 'xml':
		variables = {'belongList': belongList}
		return render_to_response('xml/belongs.xml', RequestContext(request, variables))
	else:
		raise Http404

def getTargets(request):
	id = request.POST['fid']
	fabric = Fabric.objects.get(id = id)
	if fabric.image:
		image_url = fabric.image.url
	else:
		image_url = null
	if fabric.thumb:
		thum_url = fabric.thumb.url
	else:
		thum_url = null
	if fabric.belonging:
		mask = fabric.belonging.mask.url
	else: 
		mask = 0
	variables = {'name':fabric.name, 'id':fabric.id, 'width':fabric.width, 'height':fabric.height, 'path':image_url, 'thum_url':thum_url, 'mask':mask}
	return HttpResponse(json.dumps(variables), mimetype='application/json')
'''	
	newList = []
	try:
		idList = request.POST['idList']
	except:
		raise Http404
	idList = str(idList)
	idList = idList.split(';')
	for id in idList:
		newList.append(int(id))
	print newList
	fabricList = Fabric.objects.filter(id__in = newList)
	print fabricList
	variables = {'fabricList': fabricList}
	return render_to_response('xml/fabriclist.xml', RequestContext(request, variables))
'''	



def getFabricList(request):
	user = request.user
	categoryId = request.POST['cid']
	valid = request.POST['Visible'].lower() == 'true' if request.POST.has_key('Visible') else True
	'''
	if level == '1':
		supersupercategory = FabricCategory.objects.get(id = uppercategory)
		supercategory_list = FabricCategory.objects.filter(supercategory = supersupercategory)
		categoryList = FabricCategory.objects.filter(supercategory__in = supercategory_list)
		fabricList = Fabric.objects.filter(fabricinformation__isnull = False, category__in = categoryList)
	elif level == '2':
		supercategory = FabricCategory.objects.get(id = uppercategory)
		categoryList = FabricCategory.objects.filter(supercategory = supercategory)
		fabricList = Fabric.objects.filter(fabricinformation__isnull = False, category__in = categoryList)
	else:
		category = FabricCategory.objects.get(id = categoryId)
		fabricList = Fabric.objects.filter(fabricinformation__isnull = False, category = category)
		print fabricList
	'''
	if user.is_authenticated():
		category = FabricCategory.objects.get(id = categoryId)
		if	user.is_staff:
			'''
			managerFabricList = Fabric.objects.filter(fabricinformation__isnull = False, category = category).order_by('-id')
			fabricList = Fabric.objects.filter(fabricinformation__isnull = True, user = user, category = category).order_by('-id')
			'''
			managerFabricList = Fabric.objects.filter(category = category).order_by('-id')
			fabricList = []
		else:
			managerFabricList = Fabric.objects.filter(~Q(user = user), fabricinformation__isnull = False, category = category, valid = valid).order_by('-id')
			fabricList = Fabric.objects.filter(user = user, category = category).order_by('-id')

		if settings.ACCESS_CONTROL_BY_CLIENT_GROUP and user.is_authenticated() and not user.userprofile.userType > 1:
			managerFabricList = managerFabricList.filter(Q(allowed_groups__isnull = True) | Q(allowed_groups = user.userprofile.client_group)).distinct()
			fabricList = fabricList.filter(Q(allowed_groups__isnull = True) | Q(allowed_groups = user.userprofile.client_group)).distinct()

		variables = {'fabricList': fabricList, 'managerFabricList': managerFabricList, 'user':user}
		return render_to_response('xml/fabriclist.xml', RequestContext(request, variables))
	
	
	else:
		category = FabricCategory.objects.get(id = categoryId)
		managerFabricList = Fabric.objects.filter(fabricinformation__isnull = False, category = category, valid = valid).order_by('-id')
			
		#if settings.ACCESS_CONTROL_BY_CLIENT_GROUP and user.is_authenticated() and not user.userprofile.userType > 1:
			#managerFabricList = managerFabricList.filter(Q(allowed_groups__isnull = True) | Q(allowed_groups = user.userprofile.client_group)).distinct()
		managerFabricList = managerFabricList.filter(allowed_groups__isnull = True).distinct()
		
		variables = {'managerFabricList': managerFabricList, 'user':user}
		return render_to_response('xml/fabriclist.xml', RequestContext(request, variables))



## get Fabric list
# Return: xml
def getFabricListManager(request):
	try:
		categoryId = int(request.POST['categoryId'])
	except:
		raise Http404

	user = request.user
	
	#fabricList = Fabric.objects.filter(valid = True, fabricinformation__isnull = False, category = category)
	#no matter valid (all valid include False, True)
	
	category = FabricCategory.objects.get(id = categoryId)
	
	#fabricList = Fabric.objects.filter(fabricinformation__isnull = False, category = category)
	fabricList = Fabric.objects.filter(category = category).order_by('-id')
	if settings.ACCESS_CONTROL_BY_CLIENT_GROUP and user.is_authenticated() and not user.userprofile.userType > 1:
		fabricList = fabricList.filter(Q(allowed_groups__isnull = True) | Q(allowed_groups = user.userprofile.client_group)).distinct()
	
	variables = {'fabricList': fabricList}
	return render_to_response('xml/fabriclist.xml', RequestContext(request, variables))

## create Fabric
# Return: json - {success: True/False, [id: <created_fabric_id>]}

@csrf_exempt
def changeFabric(request):

	imageUrl = request.POST['imageSrc']
	imageName = request.POST['imgName']
	FID = request.POST['FID']
	name = imageName + '.png'
	valid = request.POST['Visible'].lower() == 'true' if request.POST.has_key('Visible') else False  # Default = False
	user = request.user
	fabricCount = user.userprofile.userFabricCount
	userCount = Fabric.objects.filter(user=user).count()

	if userCount >= fabricCount and not user.is_superuser:
		variables = {'success': False, 'reason': 'CountOver'}
		return HttpResponse(json.dumps(variables), mimetype='application/json')

	try:
		categoryId = int(request.POST['CID'])
		category = FabricCategory.objects.get(id=categoryId)
	except ObjectDoesNotExist:
		variables = {'success': False, 'reason': 'NoCategory'}
		return HttpResponse(json.dumps(variables), mimetype='application/json')

	user = request.user
	if user.is_anonymous():
		variables = {'success': False, 'reason': 'Anonymous'}
		return HttpResponse(json.dumps(variables), mimetype='application/json')
	else:
		try:
			orderValue = Fabric.objects.filter(category=category).aggregate(Min('orderValue'))['orderValue__min'] - 1
		except:
			orderValue = 0

	fabricCount = Fabric.objects.filter(user=request.user).count()

	if fabricCount >= request.user.userprofile.userFabricCount and not request.user.is_superuser:
		variables = {'success': False, 'reason': 'countOver'}
		return HttpResponse(json.dumps(variables), mimetype='application/json')

	fabric = Fabric(name=name, valid=valid, user=user, category=category, orderValue=orderValue)
	fabric.save()
	savename = 'c:/var_w3d/www/media/' + str(fabric.id) + '.png'
	fabricImage = urllib.urlretrieve(imageUrl, savename)
	image_filename = 'data/fabric_images/' + str(fabric.id / 10000) + '/' + str(fabric.id) + '.png'
	im = Image.open(savename)
	fabricDpi = im.save(savename, dpi=(160, 160))
	fabric.image.save(image_filename, File(open(fabricImage[0], 'rb')))
	os.remove(savename)
	img = Image.open(StringIO(fabric.image.read()))
	
	try:
		fabric.dpi = img.info['dpi'][0]
	except KeyError:
		pass

	fabric.width, fabric.height = img.size

	THUMBNAIL_SIZE = (115, 115)
	IMAGE_TYPE = imghdr.what(fabric.image.path) if imghdr.what(fabric.image.path) is not None else 'jpeg'
	img.thumbnail(THUMBNAIL_SIZE, Image.ANTIALIAS)
	temp_handle = StringIO()
	img.save(temp_handle, IMAGE_TYPE)
	temp_handle.seek(0)
	thumb_filename = 'data/fabric_thumbs/' + str(fabric.id / 10000) + '/' + str(fabric.id) + '.png'
	fabric.thumb.save(thumb_filename, ContentFile(temp_handle.read()))
	thum_url = settings.MEDIA_URL + image_filename
	responsePath = settings.MEDIA_URL + thumb_filename
	oriFabricObj = Fabric.objects.get(id = FID)
	oriFabricInformationList = FabricInformation.objects.filter(fabric = oriFabricObj)
	'''
	if oriFabricInformationList.count() > 0:
		print('if start')
		oriFabricInformationObj = oriFabricInformationList[0]
		print(oriFabricInformationObj, 'ddddddddddddddd')
		FabricInformationObj = FabricInformation(fabric = fabric, code = oriFabricInformationObj.code, weight = oriFabricInformationObj.weight, width = oriFabricInformationObj.width, composition = oriFabricInformationObj.composition, price = oriFabricInformationObj.price, oneRepeatSize = oriFabricInformationObj.oneRepeatSize, text = oriFabricInformationObj.text)
		print('fabirc', fabric)
		print('code', oriFabricInformationObj.code)
		print('weight', oriFabricInformationObj.weight)
		print('width', oriFabricInformationObj.width)
		print('fabirc', fabric)
		print('fabirc', fabric)
		FabricInformationObj.save()
		print('???????')
		oriLaundryTagsList = LaundryTags.objects.filter(fabricInfo=oriFabricInformationObj)
		print(oriLaundryTagsList)
		print('abcdqweqweqwe')
		if oriLaundryTagsList.count() > 0:
			oriLaundryTagsObj = oriLaundryTagsList[0]
			LaundryTagsObj = LaundryTags.objects.get(fabricInfo = FabricInformationObj)
			LaundryTagsObj.tag1 = oriLaundryTagsObj.tag1
			LaundryTagsObj.tag2 = oriLaundryTagsObj.tag2
			LaundryTagsObj.tag3 = oriLaundryTagsObj.tag3
			LaundryTagsObj.tag4 = oriLaundryTagsObj.tag4
			LaundryTagsObj.tag5 = oriLaundryTagsObj.tag5
			LaundryTagsObj.tag6 = oriLaundryTagsObj.tag6
			LaundryTagsObj.tag7 = oriLaundryTagsObj.tag7
			LaundryTagsObj.save()
	'''

	variables = {'success': True, 'id': fabric.id, 'filepath': responsePath, 'imgWidth': fabric.width, 'imgHeight': fabric.height, 'dpi': fabric.dpi, 'thum_url': thum_url, 'name': name}
	return HttpResponse(json.dumps(variables), mimetype='application/json')

@csrf_exempt
def repeatSave(request):
	x = int(request.POST['x'])
	y = int(request.POST['y'])
	w = int(request.POST['w'])
	h = int(request.POST['h'])
	imageName = request.POST['imgName']
	FID = request.POST['FID']
	imgWidth = int(request.POST['imgWidth'])
	imgHeight = int(request.POST['imgHeight'])
	try:
		categoryId = request.POST['CID']
		category = FabricCategory.objects.get(id = categoryId)
	except ObjectDoesNotExist:
		variables = {'success': False, 'reason': 'NoCategory'}
		return HttpResponse(json.dumps(variables), mimetype='application/json')
	user = request.user
	if user.is_anonymous():
		variables = {'success': False, 'reason': 'Anonymous'}
		return HttpResponse(json.dumps(variables), mimetype='application/json')
	else:
		try:
			orderValue = Fabric.objects.filter(category = category).aggregate(Min('orderValue'))['orderValue__min'] - 1
		except:
			orderValue = 0
	fabricCount = user.userprofile.userFabricCount

	userCount = Fabric.objects.filter(user=user).count()

	if userCount >= fabricCount and not request.user.is_superuser:
		variables = {'success': False, 'reason': 'CountOver'}
		return HttpResponse(json.dumps(variables), mimetype='application/json')
	category.uploadCount = category.uploadCount + 1
	print('count')
	fabric = Fabric(name = category.uploadCount, valid = True, user = user, category = category, orderValue = orderValue)
	fabric.save()
	category.save()
	
	fabricImage = Fabric.objects.get(id=FID)
	im = Image.open(fabricImage.image)
	oriImageW = im.size[0]
	oriImageH = im.size[1]
	imgRatio = float(oriImageW)/float(imgWidth)

	crop_x = int(x * imgRatio)
	crop_y = int(y * imgRatio)
	crop_w = int(w * imgRatio)
	crop_h = int(h * imgRatio)
	fabricRepeat = im.crop((crop_x, crop_y, crop_x + crop_w, crop_y + crop_h))

	temp_handle = StringIO()
	fabricRepeat.save(temp_handle, 'png')
	temp_handle.seek(0)
	
	image_filename = 'data/fabric_images/' + str(fabric.id/10000) + '/' + str(fabric.id) + '.png'
	fabric.image.save(image_filename, ContentFile(temp_handle.read()))
	img = Image.open(StringIO(fabric.image.read()))
	try:
		fabric.dpi = img.info['dpi'][0]
	except KeyError:
		pass

	fabric.width, fabric.height = img.size
	THUMBNAIL_SIZE = (115, 115)
	IMAGE_TYPE = imghdr.what(fabric.image.path) if imghdr.what(fabric.image.path) is not None else 'jpeg'
	img.thumbnail(THUMBNAIL_SIZE, Image.ANTIALIAS)
	temp_handle = StringIO()
	img.save(temp_handle, IMAGE_TYPE)
	temp_handle.seek(0)
	thumb_filename = 'data/fabric_thumbs/' + str(fabric.id/10000) + '/' + str(fabric.id) + '.' + IMAGE_TYPE
	fabric.thumb.save(thumb_filename, ContentFile(temp_handle.read()))
	thum_url = settings.MEDIA_URL + image_filename
	responsePath = settings.MEDIA_URL + thumb_filename

	variables = {'success': True, 'fabricId': fabric.id, 'name': fabric.name, 'thumb_url': fabric.thumb.url}

	imageName =  fabricImage.image.url.split('/')[-1]
	imagePath = str(fabricImage.image.path.replace(imageName, ''))
	resizeImgName = imagePath+'resize_'+imageName
	information = FabricInformation(fabric = fabric, code = '', weight = '', width = '', composition = '', price = '', oneRepeatSize = '', text = '')
		
	try:
		information.save()
	except Exception as e:
		try:
			transaction.rollback()
		except Exception as e:
			print('errrrr ', e)

	
	try:
		laundrytags = information.laundrytags
	except Exception as e:
		transaction.rollback()

	try:
		laundrytags.save()
	except Exception as e:
		transaction.rollback()

	if os.path.isfile(resizeImgName):
  		os.remove(resizeImgName)
		print('delete')
	else:
		print('not exist')

	fabricImage.delete()
	
	return HttpResponse(json.dumps(variables), mimetype='application/json')
	


@csrf_exempt
def createFabric(request):
	valid = request.POST['Visible'].lower() == 'true' if request.POST.has_key('Visible') else False # Default = False
	files = request.FILES.getlist('file-image-fabric')
	print(files)
	for file in files:
		try:
			categoryId = request.POST['CID']
			category = FabricCategory.objects.get(id = categoryId)
		except ObjectDoesNotExist:
			variables = {'success': False, 'reason': 'NoCategory'}
			return HttpResponse(json.dumps(variables), mimetype='application/json')
		user = request.user
		if user.is_anonymous():
			variables = {'success': False, 'reason': 'Anonymous'}
			return HttpResponse(json.dumps(variables), mimetype='application/json')
		else:
			try:
				orderValue = Fabric.objects.filter(category = category).aggregate(Min('orderValue'))['orderValue__min'] - 1
			except:
				orderValue = 0

		fabricCount = user.userprofile.userFabricCount

		userCount = Fabric.objects.filter(user=user).count()

		if userCount >= fabricCount and not request.user.is_superuser:
			variables = {'success': False, 'reason': 'CountOver'}
			return HttpResponse(json.dumps(variables), mimetype='application/json')

		category.uploadCount = category.uploadCount + 1

		fabric = Fabric(name = category.uploadCount, valid = valid, user = user, category = category, orderValue = orderValue)
		fabric.save()
		category.save()
		IMAGE_EXTENSION = os.path.splitext(file.name)[-1]
		#fabricImage = request.FILES.getlist('file-image-fabric')

		image_filename = 'data/fabric_images/' + str(fabric.id/10000) + '/' + str(fabric.id) + IMAGE_EXTENSION
		
		fabric.image.save(image_filename, ContentFile(file.read()))

		orientationImg = Image.open(fabric.image.path)
		orientationImg.save(str(fabric.image.path))
		orientationImg.close()

		img = Image.open(StringIO(fabric.image.read()))
		
		try:
			fabric.dpi = img.info['dpi'][0]
		except KeyError:
			pass

		fabric.width, fabric.height = img.size

		THUMBNAIL_SIZE = (115, 115)
		IMAGE_TYPE = imghdr.what(fabric.image.path) if imghdr.what(fabric.image.path) is not None else 'jpeg'
		img.thumbnail(THUMBNAIL_SIZE, Image.ANTIALIAS)
		temp_handle = StringIO()
		img.save(temp_handle, IMAGE_TYPE)
		temp_handle.seek(0)
		thumb_filename = 'data/fabric_thumbs/' + str(fabric.id/10000) + '/' + str(fabric.id) + IMAGE_EXTENSION
		fabric.thumb.save(thumb_filename, ContentFile(temp_handle.read()))
		thum_url = settings.MEDIA_URL + image_filename
		responsePath = settings.MEDIA_URL + thumb_filename
		
		information = FabricInformation(fabric = fabric, code = '', weight = '', width = '', composition = '', price = '', oneRepeatSize = '', text = '')
		
		try:
			information.save()
		except Exception as e:
			try:
				transaction.rollback()
			except Exception as e:
				print('errrrr ', e)

		
		try:
			laundrytags = information.laundrytags
		except Exception as e:
			transaction.rollback()

		try:
			laundrytags.save()
		except Exception as e:
			transaction.rollback()

		imgList = []
		variables = {'success': True, 'id': fabric.id, 'filepath': responsePath, 'imgWidth':fabric.width, 'imgHeight':fabric.height, 'dpi':fabric.dpi, 'thum_url':thum_url, 'name':file.name}
		imgList.append(variables)
		
		print(fabric.image.url)

	return HttpResponse(json.dumps(imgList), mimetype='application/json')

@csrf_exempt	
def createProductFabric(request):
	try:		
		userId = int(request.POST['UID'])
		productId = int(request.POST['PID'])
		layerName = request.POST['LayerName']
		layerIndex = int(request.POST['LayerIndex'])
		groupIndex = int(request.POST['GroupIndex'])
		grids = request.POST['Grids']
		fabricImage = request.FILES['FabricImage']
		fabricThumb = request.FILES['FabricThumb']
		fabricMask = request.FILES['FabricMask']
		dpi = request.POST['DPI']
		width = request.POST['Width']
		height = request.POST['Height']
	except:
		raise Http404
	
	try:
		product = Product.objects.get(id = productId)
		user = User.objects.get(id = userId)
	except ObjectDoesNotExist:
		raise Http404
	
	belonging= createBelongingToProduct(product, layerName, layerIndex, groupIndex, grids)
	orderValue = 0
	valid = request.POST['Visible'].lower() == 'true' if request.POST.has_key('Visible') else True
	fabric = Fabric(name = layerName, valid = valid, user = user, category = None, orderValue = orderValue, belonging = belonging, dpi = dpi, width = width, height = height)
	fabric.save()	
	
	# Fabric Image Uploading
	filename = 'data/fabric_images/' + str(fabric.id/10000) + '/' + str(fabric.id) + '.jpg'
	image_content = ContentFile(fabricImage.read())
	fabric.image.save(filename, image_content)
	
	# Fabric Thumb Uploading
	filename = 'data/fabric_thumbs/' + str(fabric.id/10000) + '/' + str(fabric.id) + '.jpg'
	thumb_content = ContentFile(fabricThumb.read())
	fabric.thumb.save(filename, thumb_content)
	
	# Fabric Mask Uploading
	filename = 'data/fabric_masks/' + str(fabric.id/10000) + '/' + str(fabric.id) + '.png'
	mask_content = ContentFile(fabricMask.read())	
	belonging.mask.save(filename, mask_content)
	
	variables = {'success': True, 'id': fabric.id}
	return HttpResponse(json.dumps(variables))

def findUserByCategory(fabricCategory):
	if fabricCategory.supercategory:
		return findUserByCategory(fabricCategory.supercategory)
	else:
		return fabricCategory

def createManagerFabric(request):
	try:
		name = request.POST['name']
		categoryId = int(request.POST['cid'])

		code = request.POST['code']
		weight = request.POST['weight']
		width = request.POST['width']
		composition = request.POST['composition']
		price = request.POST['price']
		oneRepeatSize = request.POST['size']
		text = request.POST['text']

		oneRepeatImage = request.POST['onerptimg'].lower()
		mappingImage = request.POST['mappingImg'].lower()
		detailImages = request.POST['detailimg'].lower()

		strLaundryTags = request.POST['laundryTags']
		str_allowed_group_ids = request.POST['allowed_group_ids']
		valid = True
		#valid = request.POST['Visible'].lower() == 'true' if request.POST.has_key('Visible') else False  # Default = False
	except:
		raise Http404

	try:
		fid = request.POST['fid']
		origin_fabric = Fabric.objects.get(id=fid)
	except:
		origin_fabric = None

	try:
		category = FabricCategory.objects.get(id=categoryId)
	except ObjectDoesNotExist:
		raise Http404

	try:
		orderValue = Fabric.objects.filter(category=category).aggregate(Max('orderValue'))['orderValue__max'] + 1
	except:
		orderValue = 0

	fabricCount = Fabric.objects.filter(user=request.user).count()

	if fabricCount >= request.user.userprofile.userFabricCount and not request.user.is_superuser and fid != None:
		variables = {'success': False, 'reason': '超过了面料上传数'}
		return HttpResponse(json.dumps(variables))

	thisUser = UserProfile.objects.get(userCategory=findUserByCategory(category))

	fabric = Fabric(name=name, user=thisUser.user, category=category, orderValue=orderValue, valid=valid)
	fabric.save()

	THUMBNAIL_SIZE = (115, 115)
	IMAGE_PATH = media_url2path(oneRepeatImage)
	IMAGE_FILENAME = os.path.split(IMAGE_PATH)[-1]
	IMAGE_EXTENSION = os.path.splitext(IMAGE_FILENAME)[-1][1:]
	IMAGE_TYPE = imghdr.what(IMAGE_PATH)
	imgObj = Image.open(IMAGE_PATH)
	'''
	try:
		fabric.dpi = imgObj.info['dpi'][0]
	except KeyError:
		pass
	fabric.width, fabric.height = imgObj.size
	'''
	temp_handle = StringIO()
	imgObj.save(temp_handle, IMAGE_TYPE)
	temp_handle.seek(0)
	fabric.image.save('data/fabric_images/%s/%s.%s' % (str(fabric.id / 10000), str(fabric.id), IMAGE_EXTENSION), ContentFile(temp_handle.read()), save=False)
	imgObj.thumbnail(THUMBNAIL_SIZE, Image.ANTIALIAS)
	temp_handle.truncate(0)
	imgObj.save(temp_handle, IMAGE_TYPE)
	temp_handle.seek(0)
	fabric.thumb.save('data/fabric_thumbs/%s/%s.%s' % (str(fabric.id / 10000), str(fabric.id), IMAGE_EXTENSION), ContentFile(temp_handle.read()))
	if len(mappingImage) > 0:
		IMAGE_PATH = media_url2path(mappingImage)
		IMAGE_FILENAME = os.path.split(IMAGE_PATH)[-1]
		IMAGE_EXTENSION = os.path.splitext(IMAGE_FILENAME)[-1][1:]
		IMAGE_TYPE = imghdr.what(IMAGE_PATH)
		imgObj = Image.open(IMAGE_PATH)

		try:
			fabric.dpi = imgObj.info['dpi'][0]
		except KeyError:
			pass

		fabric.width, fabric.height = imgObj.size
		temp_handle = StringIO()
		imgObj.save(temp_handle, IMAGE_TYPE)
		temp_handle.seek(0)
		fabric.mappingImage.save(
			'data/fabric_mappingImages/%s/%s.%s' % (str(fabric.id / 10000), str(fabric.id), IMAGE_EXTENSION),
			ContentFile(temp_handle.read()), save=False)
	else:
		IMAGE_PATH = media_url2path(oneRepeatImage)
		IMAGE_FILENAME = os.path.split(IMAGE_PATH)[-1]
		IMAGE_EXTENSION = os.path.splitext(IMAGE_FILENAME)[-1][1:]
		IMAGE_TYPE = imghdr.what(IMAGE_PATH)
		imgObj = Image.open(IMAGE_PATH)

		try:
			fabric.dpi = imgObj.info['dpi'][0]
		except KeyError:
			pass

		fabric.width, fabric.height = imgObj.size
		temp_handle = StringIO()
		imgObj.save(temp_handle, IMAGE_TYPE)
		temp_handle.seek(0)
		fabric.mappingImage.save('data/fabric_mappingImages/%s/%s.%s' % (str(fabric.id / 10000), str(fabric.id), IMAGE_EXTENSION), ContentFile(temp_handle.read()), save=False)

	detailImageURLList = detailImages.split(';')
	if not '' in detailImageURLList:
		for index, detailImageURL in enumerate(detailImageURLList):
			IMAGE_PATH = media_url2path(detailImageURL)
			IMAGE_FILENAME = os.path.split(IMAGE_PATH)[-1]
			IMAGE_TYPE = imghdr.what(IMAGE_PATH)
			fabricDetail = DetailImage(fabric=fabric)
			imgObj = Image.open(IMAGE_PATH)
			temp_handle.truncate(0)
			imgObj.save(temp_handle, IMAGE_TYPE)
			temp_handle.seek(0)
			fabricDetail.image.save('data/fabric_details/%s/%s/%s' % (str(fabric.id / 10000), str(fabric.id), IMAGE_FILENAME), ContentFile(temp_handle.read()), save=False)
			imgObj.thumbnail(THUMBNAIL_SIZE, Image.ANTIALIAS)
			temp_handle.truncate(0)
			imgObj.save(temp_handle, IMAGE_TYPE)
			temp_handle.seek(0)
			fabricDetail.thumb.save('data/fabric_details/%s/%s/thumb_%s' % (str(fabric.id / 10000), str(fabric.id), IMAGE_FILENAME), ContentFile(temp_handle.read()))

	information = FabricInformation(
		fabric=fabric,
		code=code,
		weight=weight,
		width=width,
		composition=composition,
		price=price,
		oneRepeatSize=oneRepeatSize,
		text=text,
	)
	print('111111111111111111')
	try:
		information.save()
	except Exception as e:
		try:
			transaction.rollback()
		except Exception as e:
			print('errrrr ', e)
			
	print('22222222222')

	try:
		laundrytags = information.laundrytags
	except Exception as e:
		transaction.rollback()

	print('abababababab')

	for i, tag in enumerate(strLaundryTags.split(';')):
		laundrytags.__dict__['tag%s' % str(i + 1)] = True if tag == '1' else False

	print('acacacacacac')
	try:
		laundrytags.save()
	except Exception as e:
		transaction.rollback()

	print('aaaaaaaaa')
	fabric.allowed_groups.clear()
	allowed_group_ids = str_allowed_group_ids.split('-')
	for clientGroup in ClientGroup.objects.filter(id__in=[allowed for allowed in allowed_group_ids if allowed]):
		access_through = Access_to_fabric(client_group=clientGroup, fabric=fabric)
		access_through.save()

	print('end')

	# if modifying
	if origin_fabric:
		fabric.orderValue = origin_fabric.orderValue
		fabric.simulationCount = origin_fabric.simulationCount
		try:
			fabric.save()
		except Exception as e:
			print('err ', e)
		origin_fabric.delete()
	else:
		fabric.save()
		category.uploadCount = category.uploadCount + 1
		category.save()

	variables = {'success': True, 'id': fabric.id}
	print(variables)
	return HttpResponse(json.dumps(variables))

'''
def getFabricInformation(request):
	try:
		fabricId = request.POST['fid']
		fabric = Fabric.objects.filter(id = fabricId)[0]
	except Exception as e:
		raise Http404
		
	try:
		fabric.fabricinformation
		fabric.fabricinformation.laundrytags
	except:
		information = FabricInformation(
			fabric = fabric, code = '', weight = '', width = '', composition = '', price = '', oneRepeatSize = '', text = '',
		)
		information.save()

		laundrytags = information.laundrytags
		for i in range(1,8):
			laundrytags.__dict__['tag%s' % str(i)] = False
		laundrytags.save()
		
	strLaundrytags = ''
	for i in range(1, 8):
		tag = '1' if fabric.fabricinformation.laundrytags.__dict__['tag%s' % str(i)] else '0'
		strLaundrytags += tag
		print('strL',strLaundrytags)
	allowed_group_ids = '-'.join([str(clientGroup.id) for clientGroup in fabric.allowed_groups.all()])
	fabric_categorys = FabricCategory.objects.filter(level__in=(2,3))
	
	mappingImage = ""
	
	try:
		mappingImage = fabric.mappingImage.url
	except:
		pass
		
	variables = {'fabric': fabric, 'laundrytags': strLaundrytags, 'allowed_group_ids': allowed_group_ids, 'mappingImage': mappingImage}
	return render_to_response('xml/fabricinformation.xml', RequestContext(request, variables))

'''



#원단정보 불러오기
def getFabricInformation(request):
	try:
		fabricId = request.POST['fid']
		fabric = Fabric.objects.filter(id = fabricId)[0]
		print('1')
	except Exception as e:
		print('2')
		raise Http404
	'''
	if(FabricInformation.objects.filter(fabric=fabric).count()==0):
		print('3-0')
		information = FabricInformation(
			fabric = fabric, code = '', weight = '', width = '', composition = '', price = '', oneRepeatSize = '', text = '',
		)
		print('3-1')
		information.save()
		print('3-2')
	'''
	try:
		print('3-0')
		fabric.fabricinformation
		print('3-1')
	except:
		print('asdfasdfasdf', fabric.id)
		print('3-2')
		information = FabricInformation(
			fabric = fabric, code = '', weight = '', width = '', composition = '', price = '', oneRepeatSize = '', text = '',
		)
		print('3-3')
		try:
			print('3-4')
			information.save()
		except Exception as e:
			print('error ', e)
		print('3-5')

	try:
		print('4-0')
		fabric.fabricinformation.laundrytags
		print('4-1')
	except:
		print('4-2')
		laundrytags = LaundryTags(fabricInfo = information)
		print('4-3')
		
		laundrytags.save()
		print('4-4')

	strLaundrytags = ''
	for i in range(1, 8):
		tag = '1' if fabric.fabricinformation.laundrytags.__dict__['tag%s' % str(i)] else '0'
		strLaundrytags += tag
		print('strL',strLaundrytags)
	allowed_group_ids = '-'.join([str(clientGroup.id) for clientGroup in fabric.allowed_groups.all()])
	fabric_categorys = FabricCategory.objects.filter(level__in=(2,3))
	
	mappingImage = ""
	
	try:
		mappingImage = fabric.mappingImage.url
	except:
		pass
		
	variables = {'fabric': fabric, 'laundrytags': strLaundrytags, 'allowed_group_ids': allowed_group_ids, 'mappingImage': mappingImage}
	print(variables)
	return render_to_response('xml/fabricinformation.xml', RequestContext(request, variables))

def createBelongingToProduct(product, layerName, layerIndex, groupIndex, grids):
	belonging = BelongingToProduct(product = product, layerName = layerName, layerIndex = layerIndex, groupIndex = groupIndex, grids =grids)
	belonging.save()
	return belonging

@csrf_exempt
@login_required
def uploadTempFabricImage(request):
	# return object for json
	response = {}
	
	if not request.FILES.has_key('qqfile'):
		# no file
		response = {'success': False, 'reason': "NoFile"}
	else:		
		# get size limit
		if request.GET.has_key('imgSizeLimit'):
			tempSizeLimit = request.GET['imgSizeLimit']
			imgSizeLimit = (int(tempSizeLimit.split('x')[0]), int(tempSizeLimit.split('x')[1]))
		else:
			imgSizeLimit = (2560, 1440)
			
		# handle uploaded file
		try:
			imgUploadResult = handleUploadedImg(request, 'qqfile', 'data/fabric_temps/' + str(request.user.id) + '/', imgSizeLimit)
		except UploadedImgFileError as e:
			# exception handling for uploaded image file error
			response = {'success':False, 'reason':e.reason}
			return HttpResponse(json.dumps(response))
			

		# return success message
		response = {'success':True, 'filepath':settings.MEDIA_URL+imgUploadResult['path'], 'imgWidth': str(imgUploadResult['size'][0]), 'imgHeight': str(imgUploadResult['size'][1])}
	
	# return reponse dictionary as json type
	return HttpResponse(json.dumps(response))

def deleteFabric(request):
	try:
		fabricId = int(request.POST['fid'])
	except:
		raise Http404
	
	try:
		fabric = Fabric.objects.get(id = fabricId)
	except ObjectDoesNotExist:
		variables = {'success': False, 'reason': 'DoesNotExist'}
		return HttpResponse(json.dumps(variables), mimetype='application/json')
	
	fabric.delete()
	
	variables = {'success': True}
	return HttpResponse(json.dumps(variables), mimetype='application/json')

def changeFabricOrdering(request):
	try:
		srcFabricId = int(request.POST['srcfid'])
		dstFabricId = int(request.POST['dstfid'])
		
		srcFabric = Fabric.objects.get(id = srcFabricId)
		if not hasattr(srcFabric, 'fabricinformation'):
			information = FabricInformation(
				fabric = srcFabric, code = '', weight = '', width = '', composition = '', price = '', oneRepeatSize = '', text = '',
			)
			information.save()

			laundrytags = information.laundrytags
			for i in range(1,8):
				laundrytags.__dict__['tag%s' % str(i)] = False
			laundrytags.save()
		
	except Exception as e:
		raise Http404
	
	try:
		dstFabric = Fabric.objects.get(id = dstFabricId)
		goingForward = srcFabric.orderValue > dstFabric.orderValue
		lowerBoundary = min(srcFabric.orderValue, dstFabric.orderValue)
		upperBoundary = max(srcFabric.orderValue, dstFabric.orderValue)
		if not hasattr(dstFabric, 'fabricinformation'):
			information = FabricInformation(
				fabric = dstFabric, code = '', weight = '', width = '', composition = '', price = '', oneRepeatSize = '', text = '',
			)
			information.save()

			laundrytags = information.laundrytags
			for i in range(1,8):
				laundrytags.__dict__['tag%s' % str(i)] = False
			laundrytags.save()

	except ObjectDoesNotExist:
		dstFabric = None
		goingForward = False
		lowerBoundary = srcFabric.orderValue
		upperBoundary = None
	
	siblingFabrics = Fabric.objects.filter(category = srcFabric.category).order_by('-id')
	
	if dstFabric:
		latest = None
		siblingFabrics = siblingFabrics.filter(orderValue__gt = lowerBoundary, orderValue__lt = upperBoundary)
	else:
		latest = siblingFabrics.latest().orderValue
		siblingFabrics = siblingFabrics.filter(orderValue__gt = lowerBoundary)
	
	if goingForward:
		srcFabric.orderValue = dstFabric.orderValue
		dstFabric.orderValue += 1
		addToSiblingsOrder = 1
	else:
		srcFabric.orderValue = (dstFabric.orderValue - 1) if dstFabric else latest
		addToSiblingsOrder = -1
	
	for fabric in siblingFabrics:
		fabric.orderValue += addToSiblingsOrder
		fabric.save()
	
	srcFabric.save()
	if dstFabric:
		dstFabric.save()
	
	variables = {'success': True}
	return HttpResponse(json.dumps(variables), mimetype='application/json')

def copyFabrics(request):
	'''
	categoryFrom = "Woman"
	categoryTo =  "etc"
	
	categoryFrom = FabricCategory.objects.get(name = categoryFrom)
	categoryTo = FabricCategory.objects.get(name = categoryTo, supercategory=categoryFrom)
	
	fabrics = Fabric.objects.filter(category = categoryFrom)
	for fabric in fabrics:
		fabricInfoExist = True
		try:
			fabricinfo = fabric.fabricinformation
		except:
			fabricInfoExist = False
		fabric.pk = None
		fabric.category = categoryTo
		fabric.save()
		
		if fabricInfoExist:
			fabricinfo.pk = None
			fabricinfo.fabric = fabric
			fabricinfo.save()
	
	
	variables = {'success': True}
	'''
	return HttpResponse(json.dumps(variables), mimetype='application/json')
	
@csrf_exempt
def getFabricCategoryViewer(request):
	print('cStart')
	fabricCategory = []

	if request.user.is_superuser:
		print('1111111')
		lev1Category = FabricCategory.objects.filter(supercategory__isnull=True)
		lev2CategoryList = FabricCategory.objects.filter(supercategory = lev1Category[0].id).order_by('orderValue')
	else:
		print('222222')
		lev1Category = FabricCategory.objects.filter(id=request.user.userprofile.userCategory.id,supercategory__isnull = True)
		lev2CategoryList = FabricCategory.objects.filter(supercategory = lev1Category[0].id).order_by('orderValue')

	i = 0
	print('3333333')
	for lev2Category in lev2CategoryList:
		fabricCategory.append({'id': lev2Category.id, 'name': lev2Category.name, 'childCategory': []})
		lev3CategoryList = FabricCategory.objects.filter(supercategory=lev2Category.id).order_by('orderValue')

		for lev3Category in lev3CategoryList:
			fabricCategory[i]['childCategory'].append({'id': lev3Category.id, 'name': lev3Category.name})

		i = i + 1

	variables = {'success': True, 'fabricCategory': fabricCategory}
	return HttpResponse(json.dumps(variables), mimetype='application/json')

@csrf_exempt
def fabricResize(request):
	mode = request.POST['mode']
	pid = request.POST['pid']
	belongIndex = int(request.POST['belongIndex'])
	fids = request.POST['fids']

	fids = fids.split(',')

	user = request.user
	fabric = Fabric.objects.get(id = fids[belongIndex])

	q = resizeFabric.objects.filter(Q(smallFabric = fabric) | Q(largeFabric = fabric))
	if q.exists():
		fabric = q[0].originalFabric

	if not resizeFabric.objects.filter(originalFabric = fabric).exists():
		# resize fabric 생성
		original_img = ""
		if fabric.mappingImage:
			original_img = settings.MEDIA_ROOT + str(fabric.mappingImage)
		else:
			original_img = settings.MEDIA_ROOT + str(fabric.image)

		tmp_img = Image.open(original_img)
		img_format = tmp_img.format.lower()

		small_size = (int(round(fabric.width * 0.5)), int(round(fabric.height * 0.5)))
		large_size = (int(round(fabric.width * 1.5)), int(round(fabric.height * 1.5)))

		small_img = tmp_img.resize(small_size, Image.ANTIALIAS)
		large_img = tmp_img.resize(large_size, Image.ANTIALIAS)

		superuser = User.objects.filter(is_superuser=True)[0]


		smallFabric = Fabric(name=fabric.name, valid=True, user_id=superuser.id, category=None, orderValue=0, dpi=fabric.dpi)
		smallFabric.save()

		largeFabric = Fabric(name=fabric.name, valid=True, user_id=superuser.id, category=None, orderValue=0, dpi=fabric.dpi)
		largeFabric.save()

		# small
		f = StringIO()
		small_img.save(f, img_format)
		smallFabric.width, smallFabric.height = small_img.size
		smallFabric.image.save('data/smallImage/' + str(smallFabric.id / 10000) + '/' + str(smallFabric.id) + '.' + img_format, ContentFile(f.getvalue()))

		# large
		f2 = StringIO()
		large_img.save(f2, img_format)
		largeFabric.width, largeFabric.height = large_img.size
		largeFabric.image.save('data/largeImage/' + str(largeFabric.id / 10000) + '/' + str(largeFabric.id) + '.' + img_format, ContentFile(f2.getvalue()))

		resizedFabric = resizeFabric(originalFabric = fabric, smallFabric = smallFabric, largeFabric = largeFabric)
		resizedFabric.save()

	originalFabric = resizeFabric.objects.get(originalFabric = fabric)

	newFabricId = 0
	if mode == 's':
		newFabricId = originalFabric.smallFabric_id
	elif mode == 'o':
		newFabricId = originalFabric.originalFabric_id
	elif mode == 'l':
		newFabricId = originalFabric.largeFabric_id
	fids[belongIndex] = newFabricId
	newFids = ','.join(map(str, fids))
	simulationData = {'PID': pid, 'FIDS': newFids, 'user': user}

	variables = runSimulation(simulationData)

	variables.update({'newFid': newFabricId, 'belongIndex': belongIndex})
	return HttpResponse(json.dumps(variables), mimetype='application/json')

def isExist(request):
	fids = request.POST.getlist('fids[]')
	existFids = Fabric.objects.filter(id__in=fids).values_list('id')
	existFids = [str(fid[0]) for fid in existFids]
	return HttpResponse(json.dumps(existFids), mimetype='application/json')

def getFabricInformationViewer(request):
	try:
		fabricId = request.POST['fid']
		fabric = Fabric.objects.filter(id = fabricId)[0]
	except Exception as e:
		raise Http404
		
	try:
		fabric.fabricinformation
		fabric.fabricinformation.laundrytags
	except:
		information = FabricInformation(
			fabric = fabric, code = '', weight = '', width = '', composition = '', price = '', oneRepeatSize = '', text = '',
		)
		information.save()

		laundrytags = information.laundrytags
		for i in range(1,8):
			laundrytags.__dict__['tag%s' % str(i)] = False
		laundrytags.save()
		
	strLaundrytags = ''
	for i in range(1, 8):
		tag = '1' if fabric.fabricinformation.laundrytags.__dict__['tag%s' % str(i)] else '0'
		strLaundrytags += tag
	allowed_group_ids = '-'.join([str(clientGroup.id) for clientGroup in fabric.allowed_groups.all()])
	fabric_categorys = FabricCategory.objects.filter(level__in=(2,3))
	
	mappingImage = ""
	
	try:
		mappingImage = fabric.mappingImage.url
	except:
		pass
		
	variables = {'fabric': fabric, 'laundrytags': strLaundrytags, 'allowed_group_ids': allowed_group_ids, 'mappingImage': mappingImage}
	return HttpResponse(json.dumps(variables), mimetype='application/json')


def findFabric(request):
	findKind = int(request.POST['findKind'])
	findText = request.POST['findText']
	user = request.user
	managerFabricList = []
	fabricList = []

	if user.is_superuser:
		if findKind == 1:
			managerFabricList = Fabric.objects.filter(fabricinformation__isnull = False, name__icontains=findText, category__isnull=False).order_by('-id')
			fabricList = Fabric.objects.filter(fabricinformation__isnull = True, name__icontains=findText, category__isnull=False).order_by('-id')

		else:
			userList = UserProfile.objects.filter(company__icontains=findText)
			for obj in userList:
				userObj = User.objects.get(id=obj.user_id)
				fabricObjList= Fabric.objects.filter(user=userObj, fabricinformation__isnull=False, category__isnull=False).order_by('-id')
				for fabricObj in fabricObjList:
					managerFabricList.append(fabricObj)
				fabricObjList = Fabric.objects.filter(user=userObj, fabricinformation__isnull=True, category__isnull=False).order_by('-id')
				for fabricObj in fabricObjList:
					fabricList.append(fabricObj)

	else:
		if findKind == 1:
			managerFabricList = Fabric.objects.filter(~Q(user = user), name__icontains=findText, user=user, category__isnull=False).order_by('-id')
			fabricList = Fabric.objects.filter(name__icontains=findText, user=user, category__isnull=False).order_by('-id')
			variables = {'fabricList': fabricList, 'managerFabricList': managerFabricList, 'user': user}

	for obj in fabricList:
		obj.cId = obj.category.id

	for obj in managerFabricList:
		obj.cId = obj.category.id

	variables = {'fabricList': fabricList, 'managerFabricList': managerFabricList, 'user': user}

	return render_to_response('xml/fabriclist.xml', RequestContext(request, variables))


@csrf_exempt
def setCount(request):
	fabricCategoryList = FabricCategory.objects.filter(level = 3)

	for obj in fabricCategoryList:
		obj.uploadCount = Fabric.objects.filter(category=obj).count()
		obj.save()

	return HttpResponse(json.dumps({'success': True}), mimetype='application/json')


#OneRepeat Save 
# js = funccreateOneRepeat
@csrf_exempt
def oneRepeatSave(request):

	imageUrl = request.POST['imageSrc']
	imageName = request.POST['imgName']
	FID = request.POST['FID']
	name = imageName + '.png'
	valid = request.POST['Visible'].lower() == 'true' if request.POST.has_key('Visible') else False  # Default = False
	user = request.user
	fabricCount = user.userprofile.userFabricCount
	userCount = Fabric.objects.filter(user=user).count()

	if userCount >= fabricCount and not user.is_superuser:
		variables = {'success': False, 'reason': 'CountOver'}
		return HttpResponse(json.dumps(variables), mimetype='application/json')

	try:
		categoryId = int(request.POST['CID'])
		category = FabricCategory.objects.get(id=categoryId)
	except ObjectDoesNotExist:
		variables = {'success': False, 'reason': 'NoCategory'}
		return HttpResponse(json.dumps(variables), mimetype='application/json')

	user = request.user
	if user.is_anonymous():
		variables = {'success': False, 'reason': 'Anonymous'}
		return HttpResponse(json.dumps(variables), mimetype='application/json')
	else:
		try:
			orderValue = Fabric.objects.filter(category=category).aggregate(Min('orderValue'))['orderValue__min'] - 1
		except:
			orderValue = 0

	category.uploadCount = category.uploadCount + 1

	fabricCount = Fabric.objects.filter(user=request.user).count()

	if fabricCount >= request.user.userprofile.userFabricCount and not request.user.is_superuser:
		variables = {'success': False, 'reason': 'countOver'}
		return HttpResponse(json.dumps(variables), mimetype='application/json')

	fabric = Fabric(name=category.uploadCount, valid=valid, user=user, category=category, orderValue=orderValue)
	fabric.save()
	category.save()
	savename = 'c:/var_w3d/www/media/' + str(fabric.id) + '.png'
	fabricImage = urllib.urlretrieve(imageUrl, savename)
	image_filename = 'data/fabric_images/' + str(fabric.id / 10000) + '/' + str(fabric.id) + '.png'
	fabric.image.save(image_filename, File(open(fabricImage[0], 'rb')))
	os.remove(savename)
	img = Image.open(StringIO(fabric.image.read()))

	try:
		fabric.dpi = img.info['dpi'][0]
	except KeyError:
		pass

	fabric.width, fabric.height = img.size

	THUMBNAIL_SIZE = (115, 115)
	IMAGE_TYPE = imghdr.what(fabric.image.path) if imghdr.what(fabric.image.path) is not None else 'jpeg'
	img.thumbnail(THUMBNAIL_SIZE, Image.ANTIALIAS)
	temp_handle = StringIO()
	img.save(temp_handle, IMAGE_TYPE)
	temp_handle.seek(0)
	thumb_filename = 'data/fabric_thumbs/' + str(fabric.id / 10000) + '/' + str(fabric.id) + '.png'
	fabric.thumb.save(thumb_filename, ContentFile(temp_handle.read()))
	thum_url = settings.MEDIA_URL + image_filename
	responsePath = settings.MEDIA_URL + thumb_filename
	oriFabricObj = Fabric.objects.get(id = FID)
	oriFabricInformationList = FabricInformation.objects.filter(fabric = oriFabricObj)

	if oriFabricInformationList.count() > 0:
		oriFabricInformationObj = oriFabricInformationList[0]
		FabricInformationObj = FabricInformation(fabric = fabric, code = oriFabricInformationObj.code, weight = oriFabricInformationObj.weight, width = oriFabricInformationObj.width, composition = oriFabricInformationObj.composition, price = oriFabricInformationObj.price, oneRepeatSize = oriFabricInformationObj.oneRepeatSize, text = oriFabricInformationObj.text)
		FabricInformationObj.save()
		oriLaundryTagsList = LaundryTags.objects.filter(fabricInfo=oriFabricInformationObj)

		if oriLaundryTagsList.count() > 0:
			oriLaundryTagsObj = oriLaundryTagsList[0]
			LaundryTagsObj = LaundryTags.objects.get(fabricInfo = FabricInformationObj)
			LaundryTagsObj.tag1 = oriLaundryTagsObj.tag1
			LaundryTagsObj.tag2 = oriLaundryTagsObj.tag2
			LaundryTagsObj.tag3 = oriLaundryTagsObj.tag3
			LaundryTagsObj.tag4 = oriLaundryTagsObj.tag4
			LaundryTagsObj.tag5 = oriLaundryTagsObj.tag5
			LaundryTagsObj.tag6 = oriLaundryTagsObj.tag6
			LaundryTagsObj.tag7 = oriLaundryTagsObj.tag7
			LaundryTagsObj.save()

	variables = {'success': True, 'id': fabric.id, 'filepath': responsePath, 'imgWidth': fabric.width, 'imgHeight': fabric.height, 'dpi': fabric.dpi, 'thum_url': thum_url, 'name': name}
	return HttpResponse(json.dumps(variables), mimetype='application/json')
	
'''
@csrf_exempt
def deleteFabricCategoryDeleteUser(request):
	superCategoryList = FabricCategory.objects.filter(supercategory__isnull=True).order_by('id')
	userCategoryList = UserProfile.objects.filter(userCategory__isnull=False).order_by('id')
	userJsonList = []
	superJsonList = []
	userList = []
	for obj in userCategoryList:
		userjsonObj = {'id': obj.userCategory.id}
		userJsonList.append(userjsonObj)

	for obj in superCategoryList:
		superJsonObj = {'id': obj.id}
		superJsonList.append(superJsonObj)
	print userCategoryList
	print superCategoryList

	for obj in userCategoryList:
		userList.append(obj.userCategory.id)

	for obj in superCategoryList:
		if obj.id in userList:
			print 'ok'
		else:
			obj.delete()

	return HttpResponse(json.dumps(userList))
'''

@csrf_exempt
def deleteFabricAll(request):
	categoryId = request.POST['categoryId']
	print categoryId

	categoryObj = FabricCategory.objects.get(id=categoryId) 

	Fabric.objects.filter(category=categoryId).delete()

	categoryObj.uploadCount = 0

	categoryObj.save()

	variables = {'success': True}
	return HttpResponse(json.dumps(variables), mimetype='application/json')