# -*- coding: utf-8 -*-
from south.utils import datetime_utils as datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding model 'FabricCategory'
        db.create_table('fabric_fabriccategory', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(max_length=128)),
            ('valid', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('orderValue', self.gf('django.db.models.fields.IntegerField')()),
            ('level', self.gf('django.db.models.fields.IntegerField')(default=None, null=True)),
            ('supercategory', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['fabric.FabricCategory'], null=True)),
        ))
        db.send_create_signal('fabric', ['FabricCategory'])

        # Adding model 'Fabric'
        db.create_table('fabric_fabric', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(max_length=128)),
            ('valid', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('user', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['auth.User'])),
            ('category', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['fabric.FabricCategory'], null=True)),
            ('orderValue', self.gf('django.db.models.fields.IntegerField')()),
            ('image', self.gf('django.db.models.fields.files.ImageField')(max_length=100)),
            ('mappingImage', self.gf('django.db.models.fields.files.ImageField')(default=None, max_length=100, null=True)),
            ('thumb', self.gf('django.db.models.fields.files.ImageField')(max_length=100)),
            ('dpi', self.gf('django.db.models.fields.IntegerField')(default=None, null=True)),
            ('width', self.gf('django.db.models.fields.IntegerField')(default=None, null=True)),
            ('height', self.gf('django.db.models.fields.IntegerField')(default=None, null=True)),
            ('belonging', self.gf('django.db.models.fields.related.OneToOneField')(default=None, to=orm['fabric.BelongingToProduct'], unique=True, null=True)),
        ))
        db.send_create_signal('fabric', ['Fabric'])

        # Adding model 'FabricInformation'
        db.create_table('fabric_fabricinformation', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('fabric', self.gf('django.db.models.fields.related.OneToOneField')(to=orm['fabric.Fabric'], unique=True)),
            ('code', self.gf('django.db.models.fields.CharField')(max_length=20)),
            ('weight', self.gf('django.db.models.fields.CharField')(max_length=20)),
            ('width', self.gf('django.db.models.fields.CharField')(max_length=20)),
            ('composition', self.gf('django.db.models.fields.CharField')(max_length=20)),
            ('price', self.gf('django.db.models.fields.CharField')(max_length=20)),
            ('oneRepeatSize', self.gf('django.db.models.fields.CharField')(max_length=20)),
            ('text', self.gf('django.db.models.fields.CharField')(max_length=400)),
        ))
        db.send_create_signal('fabric', ['FabricInformation'])

        # Adding model 'BelongingToProduct'
        db.create_table('fabric_belongingtoproduct', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('product', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['product.Product'])),
            ('layerName', self.gf('django.db.models.fields.CharField')(max_length=128)),
            ('layerIndex', self.gf('django.db.models.fields.IntegerField')()),
            ('groupIndex', self.gf('django.db.models.fields.IntegerField')()),
            ('grids', self.gf('django.db.models.fields.CharField')(max_length=100)),
            ('mask', self.gf('django.db.models.fields.files.ImageField')(max_length=100)),
        ))
        db.send_create_signal('fabric', ['BelongingToProduct'])

        # Adding model 'LaundryTags'
        db.create_table('fabric_laundrytags', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('fabricInfo', self.gf('django.db.models.fields.related.OneToOneField')(to=orm['fabric.FabricInformation'], unique=True)),
            ('tag1', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('tag2', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('tag3', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('tag4', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('tag5', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('tag6', self.gf('django.db.models.fields.BooleanField')(default=False)),
            ('tag7', self.gf('django.db.models.fields.BooleanField')(default=False)),
        ))
        db.send_create_signal('fabric', ['LaundryTags'])

        # Adding model 'DetailImage'
        db.create_table('fabric_detailimage', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('fabric', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['fabric.Fabric'])),
            ('image', self.gf('django.db.models.fields.files.ImageField')(max_length=100)),
            ('thumb', self.gf('django.db.models.fields.files.ImageField')(max_length=100)),
        ))
        db.send_create_signal('fabric', ['DetailImage'])


    def backwards(self, orm):
        # Deleting model 'FabricCategory'
        db.delete_table('fabric_fabriccategory')

        # Deleting model 'Fabric'
        db.delete_table('fabric_fabric')

        # Deleting model 'FabricInformation'
        db.delete_table('fabric_fabricinformation')

        # Deleting model 'BelongingToProduct'
        db.delete_table('fabric_belongingtoproduct')

        # Deleting model 'LaundryTags'
        db.delete_table('fabric_laundrytags')

        # Deleting model 'DetailImage'
        db.delete_table('fabric_detailimage')


    models = {
        'auth.group': {
            'Meta': {'object_name': 'Group'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        'auth.permission': {
            'Meta': {'ordering': "('content_type__app_label', 'content_type__model', 'codename')", 'unique_together': "(('content_type', 'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['contenttypes.ContentType']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'fabric.belongingtoproduct': {
            'Meta': {'object_name': 'BelongingToProduct'},
            'grids': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'groupIndex': ('django.db.models.fields.IntegerField', [], {}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'layerIndex': ('django.db.models.fields.IntegerField', [], {}),
            'layerName': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'mask': ('django.db.models.fields.files.ImageField', [], {'max_length': '100'}),
            'product': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['product.Product']"})
        },
        'fabric.detailimage': {
            'Meta': {'object_name': 'DetailImage'},
            'fabric': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['fabric.Fabric']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'image': ('django.db.models.fields.files.ImageField', [], {'max_length': '100'}),
            'thumb': ('django.db.models.fields.files.ImageField', [], {'max_length': '100'})
        },
        'fabric.fabric': {
            'Meta': {'ordering': "['orderValue']", 'object_name': 'Fabric'},
            'belonging': ('django.db.models.fields.related.OneToOneField', [], {'default': 'None', 'to': "orm['fabric.BelongingToProduct']", 'unique': 'True', 'null': 'True'}),
            'category': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['fabric.FabricCategory']", 'null': 'True'}),
            'dpi': ('django.db.models.fields.IntegerField', [], {'default': 'None', 'null': 'True'}),
            'height': ('django.db.models.fields.IntegerField', [], {'default': 'None', 'null': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'image': ('django.db.models.fields.files.ImageField', [], {'max_length': '100'}),
            'mappingImage': ('django.db.models.fields.files.ImageField', [], {'default': 'None', 'max_length': '100', 'null': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'orderValue': ('django.db.models.fields.IntegerField', [], {}),
            'thumb': ('django.db.models.fields.files.ImageField', [], {'max_length': '100'}),
            'user': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['auth.User']"}),
            'valid': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'width': ('django.db.models.fields.IntegerField', [], {'default': 'None', 'null': 'True'})
        },
        'fabric.fabriccategory': {
            'Meta': {'ordering': "['orderValue']", 'object_name': 'FabricCategory'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'level': ('django.db.models.fields.IntegerField', [], {'default': 'None', 'null': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'orderValue': ('django.db.models.fields.IntegerField', [], {}),
            'supercategory': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['fabric.FabricCategory']", 'null': 'True'}),
            'valid': ('django.db.models.fields.BooleanField', [], {'default': 'True'})
        },
        'fabric.fabricinformation': {
            'Meta': {'object_name': 'FabricInformation'},
            'code': ('django.db.models.fields.CharField', [], {'max_length': '20'}),
            'composition': ('django.db.models.fields.CharField', [], {'max_length': '20'}),
            'fabric': ('django.db.models.fields.related.OneToOneField', [], {'to': "orm['fabric.Fabric']", 'unique': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'oneRepeatSize': ('django.db.models.fields.CharField', [], {'max_length': '20'}),
            'price': ('django.db.models.fields.CharField', [], {'max_length': '20'}),
            'text': ('django.db.models.fields.CharField', [], {'max_length': '400'}),
            'weight': ('django.db.models.fields.CharField', [], {'max_length': '20'}),
            'width': ('django.db.models.fields.CharField', [], {'max_length': '20'})
        },
        'fabric.laundrytags': {
            'Meta': {'object_name': 'LaundryTags'},
            'fabricInfo': ('django.db.models.fields.related.OneToOneField', [], {'to': "orm['fabric.FabricInformation']", 'unique': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'tag1': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'tag2': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'tag3': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'tag4': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'tag5': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'tag6': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'tag7': ('django.db.models.fields.BooleanField', [], {'default': 'False'})
        },
        'product.product': {
            'Meta': {'ordering': "['orderValue']", 'object_name': 'Product'},
            'category': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['product.ProductCategory']"}),
            'code': ('django.db.models.fields.CharField', [], {'max_length': '20'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'image': ('django.db.models.fields.files.ImageField', [], {'max_length': '100'}),
            'layerCount': ('django.db.models.fields.IntegerField', [], {}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'orderValue': ('django.db.models.fields.IntegerField', [], {}),
            'thumb': ('django.db.models.fields.files.ImageField', [], {'max_length': '100'}),
            'txd': ('django.db.models.fields.files.FileField', [], {'max_length': '100'}),
            'type': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'url': ('django.db.models.fields.URLField', [], {'max_length': '200'}),
            'valid': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'xml': ('django.db.models.fields.files.FileField', [], {'max_length': '100'})
        },
        'product.productcategory': {
            'Meta': {'ordering': "['orderValue']", 'object_name': 'ProductCategory'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'orderValue': ('django.db.models.fields.IntegerField', [], {}),
            'parent': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['product.ProductCategory']", 'null': 'True'}),
            'valid': ('django.db.models.fields.BooleanField', [], {'default': 'True'})
        }
    }

    complete_apps = ['fabric']