from django.conf.urls import patterns, include, url

# Uncomment the next two lines to enable the admin:
# from django.contrib import admin
# admin.autodiscover()

urlpatterns = patterns('',
    # Examples:
    # url(r'^$', 'mysite.views.home', name='home'),
    # url(r'^mysite/', include('mysite.foo.urls')),

    # Uncomment the admin/doc line below to enable admin documentation:
    # url(r'^admin/doc/', include('django.contrib.admindocs.urls')),

    # Uncomment the next line to enable the admin:
    # url(r'^admin/', include(admin.site.urls)),
		
    # Media static files management
    url(r'^media/(?P<path>.*)$', 'django.views.static.serve', {'document_root': 'C:/www/webtex3d-new/media'}),
)

urlpatterns += patterns('pages.views',
	(r'^$', 'viewer'),
	(r'^viewer$', 'viewer'),
	(r'^sendmail$', 'sendMail'),
	(r'^manager$', 'manageProduct'),
	(r'^manager/product$', 'manageProduct'),
	(r'^manager/fabric$', 'manageFabric'),
	(r'^manager/user$', 'manageUser'),
	(r'^manager/clientgroup$', 'manageClientGroup'),
	(r'^manager/simulation$', 'manageSimulation'),
	(r'^testAjax2$', 'testAjax2'),
)

urlpatterns += patterns('product.views',
	(r'^manager/product/category/getlist$', 'getProductCategoryList'),
	(r'^manager/product/category/create$', 'createProductCategory'),
	(r'^manager/product/category/modify$', 'modifyProductCategory'),
	(r'^manager/product/category/delete$', 'deleteProductCategory'),
	(r'^manager/product/category/switchorder$', 'switchProductCategoryOrder'),
	(r'^manager/product/getlistViewer$', 'getProductListViewer'),
	(r'^manager/product/getlist$', 'getProductList'),
	(r'^manager/product/create$', 'createProduct'),
	(r'^manager/product/modify$', 'modifyProduct'),
	(r'^manager/product/delete$', 'deleteProduct'),
	(r'^manager/product/changeorder$', 'changeProductOrdering'),
	(r'^manager/product/layer/getlist$', 'getLayerList'),
	(r'^viewer/product/category/getlist$', 'getProductCategoryViewer'),
)

urlpatterns += patterns('fabric.views',
	(r'^manager/fabric/category/getlist$', 'getFabricCategoryList'),
	(r'^manager/fabric/category/create$', 'createFabricCategory'),
	(r'^manager/fabric/category/modify$', 'modifyFabricCategory'),
	(r'^manager/fabric/category/delete$', 'deleteFabricCategory'),
	(r'^manager/fabric/category/switchorder$', 'switchFabricCategoryOrder'),
	(r'^manager/fabric/create$', 'createFabric'),
	(r'^manager/fabric/create_by_product$', 'createProductFabric'),
	(r'^manager/fabric/create_by_manager$', 'createManagerFabric'),
	(r'^manager/fabric/copyFabrics', 'copyFabrics'),
	(r'^manager/fabric/getlist$', 'getFabricList'),
	(r'^manager/fabric/getlist_by_manager$', 'getFabricListManager'),
	(r'^manager/fabric/getinfo$', 'getFabricInformation'),
	(r'^manager/fabric/uploadtempfabric$', 'uploadTempFabricImage'),
	(r'^manager/fabric/delete$', 'deleteFabric'),
	(r'^manager/fabric/changeorder$', 'changeFabricOrdering'),
	(r'^fabric/belonging/getlist$', 'getBelongs'),
	(r'^fabric/target$', 'getTargets'),
	(r'^viewer/fabric/category/getlist$', 'getFabricCategoryViewer'),
	(r'^fabric/resize$', 'fabricResize'),
	(r'^manager/fabric/isexist$', 'isExist'),
)

urlpatterns += patterns('users.views',
	(r'^login$', 'Login_ajax'),
	(r'^login_site$', 'Login_site'),
	(r'^logout$', 'Logout'),
	(r'^manager/user/getlist$', 'getUserList'),
	(r'^manager/user/getinfo$', 'getUserInfo'),
	(r'^manager/user/create$', 'createUser'),
	(r'^manager/user/modify$', 'modifyUser'),
	(r'^manager/user/delete$', 'deleteUser'),
	(r'^manager/clientgroup/getlist$', 'getClientGroupList'),
	(r'^manager/clientgroup/create$', 'createClientGroup'),
	(r'^manager/clientgroup/modify$', 'modifyClientGroup'),
	(r'^manager/clientgroup/delete$', 'deleteClientGroup'),
)

urlpatterns += patterns('simulation.views',
	(r'^testAjax$', 'testAjax'),
	(r'^simulation$', 'runSimulation'),
	(r'^runtex3dsim$', 'runTex3dSim'),
	(r'^testSimulation$', 'testSequence'),
	(r'^manager/simulation/cleanup$', 'cleanupSimulations'),
	(r'^preview/(?P<sim_id>\d+)/$', 'runPreview'),
)