# -*- coding:utf-8 -*-
import datetime
import os

from PIL import Image
from django.template import RequestContext
from django.shortcuts import render_to_response, get_object_or_404, redirect
from django.views.decorators.csrf import ensure_csrf_cookie
from django.contrib.auth.decorators import permission_required, user_passes_test
from users.user_check import admin_check
from django.contrib.auth.decorators import login_required
from django.http import HttpResponseRedirect, HttpResponse, Http404
from django.views.decorators.csrf import csrf_exempt
from django.core.mail import EmailMultiAlternatives
from fabric.models import FabricCategory, Fabric
from users.models import ClientGroup, UserProfile
from ctypes import *
from cStringIO import StringIO
from django.db.models import Max, Min
from django.core.files.base import ContentFile
from django.db import transaction

import json
import imghdr

from mysite import settings
from mysite.fabric.models import Fabric


@login_required(login_url='/login_site')
@ensure_csrf_cookie
def viewer(request):
	user = request.user
	if not user.is_superuser:
		nowDate = datetime.datetime.now()
		userInfo = UserProfile.objects.get(user=user)
		userDay = userInfo.userDate

		day = userDay.date() - nowDate.date()

		variables = {'day': day.days}
		return render_to_response('pages/index.html', RequestContext(request, variables))

	variables = {}
	return render_to_response('pages/index.html', RequestContext(request, variables))


@ensure_csrf_cookie
def loginPage(request):
    variables = {}
    return render_to_response('pages/login.html', RequestContext(request, variables))


@ensure_csrf_cookie
@user_passes_test(admin_check)
def manageProduct(request):
	clientGroupList = ClientGroup.objects.all()

	variables = {'clientGroupList': clientGroupList}
	return render_to_response('pages/manageProduct.html', RequestContext(request, variables))


@ensure_csrf_cookie
@user_passes_test(admin_check)
def manageFabric(request):
	clientGroupList = ClientGroup.objects.all()

	variables = {'clientGroupList': clientGroupList}
	return render_to_response('pages/manageFabric.html', RequestContext(request, variables))


@login_required()
def userFabric(request):
	clientGroupList = ClientGroup.objects.all()

	variables = {'clientGroupList': clientGroupList}
	return render_to_response('pages/userFabric.html', RequestContext(request, variables))


@ensure_csrf_cookie
@user_passes_test(admin_check)
def manageUser(request):
	clientGroupList = ClientGroup.objects.all()

	variables = {'clientGroupList': clientGroupList}
	return render_to_response('pages/manageUser.html', RequestContext(request, variables))


@ensure_csrf_cookie
@user_passes_test(admin_check)
def manageClientGroup(request):
	variables = {}
	return render_to_response('pages/manageClientGroup.html', RequestContext(request, variables))


@ensure_csrf_cookie
@user_passes_test(admin_check)
def manageSimulation(request):
	variables = {}
	return render_to_response('pages/manageSimulation.html', RequestContext(request, variables))


@csrf_exempt
def sendMail(request):
    #if request.method == "POST":
        #if not request.POST['bigImage']:
         #   response = {'success': False}
          #  return HttpResponse(json.dumps(response))

	msg = EmailMultiAlternatives("Hi", " ", 'terun707@naver.com', [
	                             'terun707@naver.com', 'sir-sir-yet-sir@hanmail.net', 'light707@texclub.com'])
	msg.attach_alternative(request.POST['content'], "text/html")
	msg.send()
	response = {'success': True}
	return HttpResponse(json.dumps(response))


@csrf_exempt
def testAjax2(request):
    #if request.method == "POST":
        #if not request.POST['bigImage']:
         #   response = {'success': False}
          #  return HttpResponse(json.dumps(response))

	variables = {"shit": True}
	response = HttpResponse(json.dumps(variables), mimetype='application/json')
	#response.__setitem__("Content-type", "application/json")
	response.__setitem__("Access-Control-Allow-Origin", "*")

	return response


@csrf_exempt
def sendPerspectiveImg(request):
	fabricId = request.POST['fabricId']

	img = Fabric.objects.get(id=fabricId)

	im = Image.open(img.image.path)

	imgRatio = float(600) / im.size[0]
	print imgRatio
	variables = {'imgURL': img.image.url,
	    'imgWidth': im.size[0] * imgRatio, 'imgHeight': im.size[1] * imgRatio, 'imgRatio': imgRatio}

	print variables

	return HttpResponse(json.dumps(variables), mimetype='application/json')


'''
@csrf_exempt
def test(request):
	if __name__ = '__main__':
	'''


@csrf_exempt
def testCrop(request):

	print('testCrop Start')

	CDLL('C:\\opencv_world412.dll')
	CDLL('C:\\opencv_world412d.dll')
	adder = CDLL('C:\\CppOnerepeatDll.dll')
	#windll.LoadLibraryA('C:\\opencv_world412.dll')
	#windll.LoadLibraryA('C:\\opencv_world412d.dll')
	#adder = windll.LoadLibraryA('C:\\CppOnerepeatDll.dll')

	#lib = ctypes.WinDLL(None, handle=adder)
	ShowRepeatPoints = adder.ShowRepeatPoints
	#ShowRepeatPoints = lib.ShowRepeatPoints
	fid = request.POST['fid']
	print(fid)
	img = Fabric.objects.get(id=fid)

	imageURL = 'c:/var_w3d/www'+img.image.url
	imageName = img.image.url.split('/')[-1]
	#imageExt = imageName.split('.')[-1]
	imagePath = str(img.image.path.replace(imageName, ''))
	ShowRepeatPoints(imageURL)
	print(imageURL)
	print(imageURL)
	print(imageURL)
	ReturnX = adder.ReturnX
	ReturnY = adder.ReturnY
	ReturnW = adder.ReturnW
	ReturnH = adder.ReturnH

	_x = ReturnX()
	_y = ReturnY()
	_w = ReturnW()
	_h = ReturnH()
	print(_x, _y, _w, _h)
	im = Image.open(img.image.path)
	print(im.size[0])
	print(im.size[1])
	if im.size[0] > 500:
		imgRatio = float(500)/im.size[0]
		heightRatio = int(im.size[1] * imgRatio)
		resize_image = im.resize((500, heightRatio))
		resize_image.save(imagePath+'resize_'+imageName)

		imageURL = img.image.url.replace(imageName, '')+'resize_'+imageName
		imageURL = imageURL.replace('\\', '/')

		_x = int(_x * imgRatio)
		_y = int(_y * imgRatio)
		_w = int(_w * imgRatio)
		_h = int(_h * imgRatio)

		print(_x, _y, _w, _h)
		resize_img = Image.open(imagePath+'resize_'+imageName)
		variables = {'x': _x, 'y': _y, 'w': _w, 'h': _h, 'imgURL': imageURL,
		    'imgW': resize_img.size[0], 'imgH': resize_img.size[1], 'fabricId': fid}
		print('showRepeat Resize End')

		return HttpResponse(json.dumps(variables), mimetype='application/json')
	print('showRepeat End')

	variables = {'x': _x, 'y': _y, 'w': _w, 'h': _h, 'imgURL': img.image.url,
	    'imgW': im.size[0], 'imgH': im.size[1], 'fabricId': fid}

	return HttpResponse(json.dumps(variables), mimetype='application/json')


'''
@csrf_exempt
def showPerspective(request):
	print('showPers Start')
	CDLL('C:\\opencv_world412.dll')
	CDLL('C:\\opencv_world412d.dll')
	adder = CDLL('C:\\CppOnerepeatDll.dll')
	SavePerspectiveImage =adder.SavePerspectiveImage
	pointX = request.POST.getlist('coordiX[]')
	pointY = request.POST.getlist('coordiY[]')
	imageSrc = request.POST['image']

	#img = Fabric.objects.get(id=412)

	imageName =  imageSrc.split('/')[-1] # resize_412.jpg
	imagePath = str(imageSrc.replace(imageName, '')) # /media....
	imageExt = imageName.split('.')[-1] # .jpg
	imgPath = 'c:/var_w3d_20191008/www'+imagePath # Image Pull Path

	imgName = str(imageName.replace('.'+imageExt, ''))
	print('==========')
	print(imageName)
	oneRepeatImage = str(imgPath + imageName)

	#ShowRepeatPoints(oneRepeatImage)
	print('showRepeat Func End')

	print('showRers Func Start')
	imageExt = str(imageExt)
	print(imgPath)
	print(imgName)
	print(imageExt)
	SavePerspectiveImage(int(pointX[0]),int(pointX[1]),int(pointX[2]),int(pointX[3]),int(
	    pointY[0]),int(pointY[1]),int(pointY[2]),int(pointY[3]),imgPath,imgName, imageExt)
	# ShowRepeatPoints(oneRepeatImage)

	print('===============')
	print('This')
	print(imageName)

	print('==============')
	ReturnX = adder.ReturnX
	ReturnY = adder.ReturnY
	ReturnW = adder.ReturnW
	ReturnH = adder.ReturnH

	_x = ReturnX()
	_y = ReturnY()
	_w = ReturnW()
	_h = ReturnH()


	ReturnPath = adder.ReturnPath
	ReturnPath.restype = c_wchar_p
	_path = ReturnPath()

	print(_path)

	#ShowRepeatPoints = adder.ShowRepeatPoints
	#ShowRepeatPoints(_path)
	print("shdfkhsdjf")

	perspectiveJson = {
		'imgURL':str(_path)
	}

	print(perspectiveJson)
	print('end')
	return HttpResponse(json.dumps(perspectiveJson), mimetype='application/json')
'''
@csrf_exempt
def showPerspective(request):

	import math
	import operator
	import cv2
	import numpy as np

	print('showPers Start')

	pointX = request.POST.getlist('coordiX[]')
	pointY = request.POST.getlist('coordiY[]')
	imageSrc = request.POST['image']

	#img = Fabric.objects.get(id=412)

	imageName = imageSrc.split('/')[-1]  # resize_412.jpg
	imagePath = str(imageSrc.replace(imageName, ''))  # /media....
	imageExt = imageName.split('.')[-1]  # .jpg
	imgPath = 'c:/var_w3d/www'+imagePath  # Image Pull Path

	imgName = str(imageName.replace('.'+imageExt, ''))
	print('==========')
	print(imageName)
	oneRepeatImage = str(imgPath + imageName)

	#ShowRepeatPoints(oneRepeatImage)
	print('showRepeat Func End')

	print('showRers Func Start')
	imageExt = str(imageExt)
	#SavePerspectiveImage(int(pointX[0]),int(pointX[1]),int(pointX[2]),int(pointX[3]),int(pointY[0]),int(pointY[1]),int(pointY[2]),int(pointY[3]),imgPath,imgName, imageExt)
	#ShowRepeatPoints(oneRepeatImage)

	# y sort
	pointArray = [[int(pointX[0]), int(pointY[0])], [int(pointX[1]), int(pointY[1])], [
	                   int(pointX[2]), int(pointY[2])], [int(pointX[3]), int(pointY[3])]]
	pointArray = sorted(pointArray, key=operator.itemgetter(1))
	# x sort idx 0, 1 x값 비교해서 크면 idx1 작으면 idx0
	# x sort idx 2, 3 x값 비교해서 크면 idx2 작으면 idx3
	print pointArray
	if pointArray[0][0] >= pointArray[1][0]:
		temp = pointArray[0]
		pointArray[0] = pointArray[1]
		pointArray[1] = temp

	if pointArray[2][0] <= pointArray[3][0]:
		temp = pointArray[2]
		pointArray[2] = pointArray[3]
		pointArray[3] = temp
	print pointArray

	w1 = math.sqrt(math.pow(pointArray[2][0] - pointArray[3][0],
	               2) + math.pow(pointArray[2][1] - pointArray[3][1], 2))
	w2 = math.sqrt(math.pow(pointArray[1][0] - pointArray[0][0],
	               2) + math.pow(pointArray[1][1] - pointArray[0][1], 2))
	h1 = math.sqrt(math.pow(pointArray[1][0] - pointArray[2][0],
	               2) + math.pow(pointArray[1][1] - pointArray[2][1], 2))
	h2 = math.sqrt(math.pow(pointArray[0][0] - pointArray[3][0],
	               2) + math.pow(pointArray[0][1] - pointArray[3][1], 2))

	if w1 < w2:
    		maxW = int(w2)
	else:
    		maxW = int(w1)

	if h1 < h2:
    		maxH = int(h2)
	else:
    		maxH = int(h1)

	pts1 = np.array([[pointArray[0][0], pointArray[0][1]], [pointArray[1][0], pointArray[1][1]], [
	                pointArray[2][0], pointArray[2][1]], [pointArray[3][0], pointArray[3][1]]], dtype=np.float32)
	pts2 = np.array([[0, 0], [maxW - 1, 0], [maxW - 1, maxH - 1],
	                [0, maxH - 1]], dtype=np.float32)
	print pts1
	print pts2

	# 여기서 원본 img를 읽는데 가로 사이즈가 작은 이미지는 ratio 적용이 안돼서 이미지가 왜곡 되는 것 같음 여기 확인하면 될 듯 함
	img = cv2.imread(imgPath+imageName, cv2.IMREAD_UNCHANGED)
	print('img', imgPath+imageName)
	M = cv2.getPerspectiveTransform(pts1, pts2)
	print('asd')
	dst = cv2.warpPerspective(img, M, (maxW, maxH))
	print('dst', dst)
	#print(imgPath + imgName + "_pers." + imageExt, dst)
	cv2.imwrite(imgPath + imgName + "_pers." + imageExt, dst)
	print('===============')
	print('This')
	print('==============')

	print(imgPath)
	print(imageName)

	'''

	#ReturnPath = adder.ReturnPath
	#ReturnPath.restype = c_wchar_p
	#_path = ReturnPath()

	#print(_path)

	#ShowRepeatPoints = adder.ShowRepeatPoints
	#ShowRepeatPoints(_path)
	'''
	"""
	perspectiveJson = {
		'imgURL':str(_path)
	}

	print(perspectiveJson)
	print('end')
	"""

	imgPath = imgPath.replace('c:/var_w3d/www', '')

	print('end')
	return HttpResponse(json.dumps({'aa': imgPath + imgName + "_pers." + imageExt}), mimetype='application/json')

#평탄화원단 저장 후 원본 삭제


def savePerspective(request):
	originalFid = request.POST['originalFid']
	newImageUrl = request.POST['image']
	imageName = request.POST['imageName']

	print imageName

	originalFabric = Fabric.objects.get(id=originalFid)

	imagePath = 'c:/var_w3d/www' + newImageUrl

	tmp_img = Image.open(imagePath)
	img_format = tmp_img.format.lower()

	orderValue = Fabric.objects.filter(category=originalFabric.category).aggregate(
	    Min('orderValue'))['orderValue__min'] - 1

	user = request.user
	fabricCount = user.userprofile.userFabricCount
	userCount = Fabric.objects.filter(user=user).count()
	category = originalFabric.category

	if userCount >= fabricCount and not request.user.is_superuser:
		variables = {'success': False, 'reason': 'CountOver'}
		return HttpResponse(json.dumps(variables), mimetype='application/json')
	category.uploadCount = category.uploadCount + 1
	print('count')

	perspectiveImage = Fabric(user=originalFabric.user, name=category.uploadCount,
	                          category=originalFabric.category, orderValue=orderValue)
	perspectiveImage.save()
	category.save()

	f = StringIO()
	tmp_img.save(f, img_format)
	perspectiveImage.width, perspectiveImage.height = tmp_img.size
	perspectiveImage.image.save('data/fabric_images/' + str(perspectiveImage.id / 10000) +
	                            '/' + str(perspectiveImage.id) + '.' + img_format, ContentFile(f.getvalue()))

	THUMBNAIL_SIZE = (115, 115)
	IMAGE_TYPE = 'jpeg'
	tmp_img.thumbnail(THUMBNAIL_SIZE, Image.ANTIALIAS)
	temp_handle = StringIO()
	tmp_img.save(temp_handle, IMAGE_TYPE)
	temp_handle.seek(0)
	thumb_filename = 'data/fabric_thumbs/' + \
	    str(perspectiveImage.id/10000) + '/' + \
	        str(perspectiveImage.id) + '.' + IMAGE_TYPE
	perspectiveImage.thumb.save(thumb_filename, ContentFile(temp_handle.read()))

	os.remove(imagePath)

	originalFabric.delete()

	return HttpResponse(json.dumps({'success':True, 'fId': perspectiveImage.id}), mimetype='application/json')
	
'''
def savePerspective(request):
	originalFid = request.POST['originalFid']
	newImageUrl = request.POST['image']
	imageName = request.POST['imageName']

	print imageName

	originalFabric = Fabric.objects.get(id = originalFid)

	imagePath = 'c:/var_w3d/www' + newImageUrl

	tmp_img = Image.open(imagePath)
	img_format = tmp_img.format.lower()

	orderValue = Fabric.objects.filter(category = originalFabric.category).aggregate(Min('orderValue'))['orderValue__min'] - 1

	user = request.user
	fabricCount = user.userprofile.userFabricCount
	userCount = Fabric.objects.filter(user=user).count()
	category = originalFabric.category

	if userCount >= fabricCount and not request.user.is_superuser:
		variables = {'success': False, 'reason': 'CountOver'}
		return HttpResponse(json.dumps(variables), mimetype='application/json')
	category.uploadCount = category.uploadCount + 1
	print('count')

	perspectiveImage = Fabric(user=originalFabric.user, name=category.uploadCount, category=originalFabric.category, orderValue=orderValue)
	perspectiveImage.save()
	category.save()

	f = StringIO()
	tmp_img.save(f, img_format)
	perspectiveImage.width, perspectiveImage.height = tmp_img.size
	perspectiveImage.image.save('data/fabric_images/' + str(perspectiveImage.id / 10000) + '/' + str(perspectiveImage.id) + '.' + img_format, ContentFile(f.getvalue()))

	THUMBNAIL_SIZE = (115, 115)
	IMAGE_TYPE = 'jpeg'
	tmp_img.thumbnail(THUMBNAIL_SIZE, Image.ANTIALIAS)
	temp_handle = StringIO()
	tmp_img.save(temp_handle, IMAGE_TYPE)
	temp_handle.seek(0)
	thumb_filename = 'data/fabric_thumbs/' + str(perspectiveImage.id/10000) + '/' + str(perspectiveImage.id) + '.' + IMAGE_TYPE
	perspectiveImage.thumb.save(thumb_filename, ContentFile(temp_handle.read()))

	os.remove(imagePath)

	return HttpResponse(json.dumps({'success':True, 'fId': perspectiveImage.id}), mimetype='application/json')
'''
