# -*- coding: utf-8 -*-
from django.template import RequestContext
from django.shortcuts import render_to_response
from django.contrib.auth.models import User, Permission
from django.http import HttpResponseRedirect, HttpResponse, Http404
from django.core.exceptions import ObjectDoesNotExist
from django.core.files.base import ContentFile
from django.db import IntegrityError
from django.db.models import Count
from cStringIO import StringIO
from django.views.decorators.csrf import csrf_exempt
from django.core.files.uploadedfile import SimpleUploadedFile
from users.models import *
from product.models import *
from fabric.models import *
from simulation.models import *
from PIL import Image, ImageDraw
from django.utils.datastructures import MultiValueDictKeyError
from httplib import HTTPResponse
from StringIO import StringIO
from django.db.models import Q

import json
import sys
import os.path
import settings
import operator
import shlex
import subprocess
import imghdr
import random
import datetime
import time
	
# Simulation Test - START
########################################################################################################################
class FakeData(object):
	POST = {}
	user = {}
	
class FakeSocket():
	def __init__(self, response_str):
		self._file = StringIO(response_str)
	def makefile(self, *args, **kwargs):
		return self._file

		
def getTestbase(count):
	products = Product.objects.filter(Q(valid = True), Q(category_id = 10) | Q(category_id = 11)  | Q(category_id = 12))
	fabrics = Fabric.objects.filter(Q(user_id=1), Q(valid = True), Q(category_id = 61) | Q(category_id = 62) | Q(category_id = 64))
	
	productSet = [''] * count
	fabricSet = [''] * count
	
	for i in range(count):
		ranPid = random.randrange(len(products))
		productSet[i] = str(products[ranPid].id)
		fabricSet[i] = str(fabrics[random.randrange(len(fabrics))].id)
		
		belongings = BelongingToProduct.objects.filter(product = products[ranPid]).order_by('id')
		
		if len(belongings) > 1:
			for j in range(len(belongings) - 1):
				fabricSet[i] += ',' + str(fabrics[random.randrange(len(fabrics))].id)
	
	return {'productSet': productSet, 'fabricSet': fabricSet}
	

def testSequence(request):
	count = int(request.GET['count'])
	testbase = getTestbase(count)
	productSet = testbase['productSet']
	fabricSet = testbase['fabricSet']
	
	
	successCount = 0
	
	testData = FakeData()
	testData.user = User.objects.get(id = 1)
	
	result = ''
	time = datetime.datetime.now() - datetime.datetime.now()
	maxtime = datetime.datetime.now() - datetime.datetime.now()
	
	for i in range(count):
		ts = datetime.datetime.now()
		testData.POST = {'PID': productSet[i], 'FIDS': fabricSet[i]}
		
		source = FakeSocket(runSimulation(testData))
		response = HTTPResponse(source)
		response.begin()
		
		string = response.read().decode('utf-8')
		
		tf = datetime.datetime.now()
		te = tf - ts
		
		time += te
		
		if string.find("true") > 0 :
			successCount += 1
			result += ' SUCCESS time: '+ str(te) + 's product: ' + productSet[i] + ' / fabric: ' + fabricSet[i] + " // " + string + '<br> '
			if te > maxtime :
				maxtime = te
			
		else:
			result += 'FAIL time: '+ str(te) + 's  product: ' + productSet[i] + ' / fabric: ' + fabricSet[i] + " // " + string + '<br> '

			
	retstr = "Time: " + str(time)  + "<br>success: " + str(successCount) +  "<br>max time: " + str(maxtime) + "<br>result: " + result

	return HttpResponse(retstr, mimetype='text/html')
########################################################################################################################
# Simulation Test - END



## run Simulation
# 1. Insert User ID for foreignKey to the simulation table
# 2. Call runTex3dParam function
#	- id: select id from simulation where user = userId
#	- fn: productId.txf
#	- pt_stc

def runSimulation(request):
	isResize = False

	try:
		if request.method == 'POST':
			productId = int(request.POST['PID'])
			fabricIds = request.POST['FIDS']
			user = request.user
	except AttributeError:
		isResize = True
		productId = request['PID']
		fabricIds = request['FIDS']
		user = request['user']

	try:
		product = Product.objects.get(id=productId)
		belongings = BelongingToProduct.objects.filter(product=product).order_by('id')
	except ObjectDoesNotExist:
		raise Http404
	
	using_fabric = fabricIds.split(',')
	filename = str(product.id/10000) + '/' + str(product.id) + '.txd'

	i = 0
	patternInfo = ''
	for belong in belongings:
		fabric = Fabric.objects.get(id = int(using_fabric[i]))
		fabric_url = ''
		try:
			if len(fabric.mappingImage.url) > 5:
				fabric_url = fabric.mappingImage.url
			else:
				fabric_url = fabric.image.url
		except:
			fabric_url = fabric.image.url
			
		fabric_fn = fabric_url#str(fabric.id/10000) + '/' + os.path.split(fabric_url)[-1]
		i += 1
		patternInfo += fabric_fn + ';' + str(fabric.dpi) + ';' + str(belong.layerIndex) + ';' + belong.grids + ' '
	
	user = None if user.is_anonymous() else user
	delsim = False
	cache_str = ' '.join((str(productId), fabricIds))
	if Simulation.objects.filter(cache_str = cache_str).exists():
		if user is not None and user.is_staff:
			pass#delsim = True
		else:
			simulation = Simulation.objects.filter(cache_str = cache_str).order_by('-id')[0]
			variables = {'success': True, 'url': simulation.image.url, 'reason': "Oldsimulation"}

			if isResize == True:
				return variables
			else:
				return HttpResponse(json.dumps(variables), mimetype='application/json')
	
	simulation = Simulation(user = user, cache_str = cache_str)
	simulation.save()
	

	result = {'success': False, 'reason': ""}
	sim_path = settings.MEDIA_ROOT + 'data/simulation/' + str(simulation.id) + '.jpg'
	save_path = 'data/simulation/' + str(simulation.id/10000) + '/' + str(simulation.id) + '.jpg'
	
	T = 10
	while T > 0 : #Max trying count : 10
		T = T - 1
		if not result['success']:
			result = runTex3dParam(str(simulation.id), filename, patternInfo)
		if result['success'] == True:		
			try:
				imgObj = Image.open(sim_path)
				temp_handle = StringIO()
				IMAGE_TYPE = imghdr.what(sim_path)
				imgObj.save(temp_handle, IMAGE_TYPE)
				temp_handle.seek(0)
				suf = SimpleUploadedFile('simulationFiles.jpg', temp_handle.read())
				simulation.image.save(save_path, suf)
				
				variables = {'success': True, 'url': simulation.image.url, 'reason': result['reason']+ " : " + str(T)}
				break
			except IOError:
				result['success'] = False
			except Exception as e:
				print "Sim image process error #" + str(simulation.id) + str(e)
			
	if not result['success'] or not variables['success']:
		print "## Simulation Error ## Cache_str:" + cache_str + " / Simulation ID:  " + str(simulation.id)
		simulation.delete()
		variables = {'success': False, 'reason': result['reason']}
	try:
		os.remove(sim_path)
	except:
		pass

	if isResize == True:
		return variables
	else:
		return HttpResponse(json.dumps(variables), mimetype='application/json')

@csrf_exempt
def testAjax(request):
	try:
		productId = int(request.POST['PID'])
		fabricIds = request.POST['FIDS']
	except:
		raise Http404
	
	try:
		user = request.user
		product = Product.objects.get(id = productId)
		belongings = BelongingToProduct.objects.filter(product = product).order_by('id')
	except ObjectDoesNotExist:
		raise Http404
	
	using_fabric = fabricIds.split(',')
	filename = str(product.id/10000) + '/' + str(product.id) + '.txd'
	
	i = 0
	patternInfo = ''
	for belong in belongings:
		try:
			fabric = Fabric.objects.get(id = int(using_fabric[i]))
			fabric_fn = str(fabric.id/10000) + '/' + os.path.split(fabric.image.url)[-1]
			i += 1
			patternInfo += fabric_fn + ';' + str(fabric.dpi) + ';' + str(belong.layerIndex) + ';' + belong.grids + ' '
		except ObjectDoesNotExist:
			raise Http404
	
	user = None if user.is_anonymous() else user
	
	cache_str = ' '.join((str(productId), fabricIds))
	if Simulation.objects.filter(cache_str = cache_str).exists():
		if user is not None and user.is_staff:
			for simulation in Simulation.objects.filter(cache_str = cache_str):
				simulation.delete()
		else:
			simulation = Simulation.objects.filter(cache_str = cache_str)[0]
			
			variables = {'success': True, 'url': simulation.image.url}
			response = HttpResponse(json.dumps(variables), mimetype='application/json')
			response.__setitem__("Access-Control-Allow-Origin", "*")

			return response
	
	simulation = Simulation(user = user, cache_str = cache_str)
	simulation.save()
	
	result = runTex3dParam(str(simulation.id), filename, patternInfo)
	
	if result == True:
		sim_path = settings.MEDIA_ROOT + 'data/simulation/' + str(simulation.id) + '.jpg'
		save_path = 'data/simulation/' + str(simulation.id/10000) + '/' + str(simulation.id) + '.jpg'
		
		imgObj = Image.open(sim_path)
		temp_handle = StringIO()
		IMAGE_TYPE = imghdr.what(sim_path)
		imgObj.save(temp_handle, IMAGE_TYPE)
		temp_handle.seek(0)
		suf = SimpleUploadedFile('simulationFiles.jpg', temp_handle.read())
		simulation.image.save(save_path, suf)
		
		os.remove(sim_path)
		
		variables = {'success': True, 'url': simulation.image.url}
	
	else:
		simulation.delete()
		variables = {'success': False}
	
	response = HttpResponse(json.dumps(variables), mimetype='application/json')
	response.__setitem__("Access-Control-Allow-Origin", "*")

	return response

## run Tex3D_Param.exe 
# ID 0(Zoom) FileName Pattern;Layer;GridGroup No.
# 3175 0.txd 15.jpg;0;2,3 10.bmp;2;0,4
def runTex3dParam(sid, fn, pt_etc):
	T = 5
	variables = {'success': False, 'reason': "#"}
	while (T > 0):
		T = T - 1
		try:
			save_path = settings.MEDIA_ROOT + 'data/simulation/' + sid + '.jpg'

			cmd = settings.MEDIA_ROOT + 'data/webtex3d/Tex3D_Param.exe {i} 0 {f} {p}'.format(i = sid, f = fn, p = pt_etc)
			args = shlex.split(cmd)
			proc = subprocess.Popen(args)
			rtn = proc.communicate()
			if os.path.exists(save_path):
				variables = {'success': True, 'reason': "Sim-True" + str(T)}
				break;
				
		except Exception as e:
			variables = {'success': False, 'reason': str(e)}
	
	return variables
	
## run Tex3D_Sim.exe 
#
def runTex3dSim(request):
	try:
		cmd = 'h:' + settings.MEDIA_ROOT + 'data/webtex3d/Tex3D_Sim.exe'
		args = shlex.split(cmd)
		proc = subprocess.Popen(args)
		variables = {'success': True}
	except:
		variables = {'success': False}
			
	return HttpResponse(json.dumps(variables), mimetype='application/json')
		
def cleanupSimulations(request):
	try:
		for simulation in Simulation.objects.all():
			simulation.delete()
		
		variables = {'success': True}
	except:
		variables = {'success': False}
	
	# delete temp simulation temp files
	dir_list = os.listdir(settings.MEDIA_ROOT + 'data/simulation/')
	for file in dir_list :
		try :
			if file.find(".jpg") > 0 and (time.time() - os.path.getmtime(settings.MEDIA_ROOT + 'data/simulation/' + file) > 5):
				os.remove(settings.MEDIA_ROOT + 'data/simulation/' + file)
		except:
			pass
	
	return HttpResponse(json.dumps(variables), mimetype='application/json')

def runPreview(request, sim_id):
	try:
		infoSimulation = Simulation.objects.get(id=sim_id)
		cache_str = infoSimulation.cache_str
		imageUrl = infoSimulation.image.url
		pid, fids = cache_str.split()
		fids = fids.split(',')
		fabricNames = []
		productName = Product.objects.get(id=pid).name
		for fid in fids:
			try:
				fabricNames.append(Fabric.objects.get(id=fid).fabricinformation.fabricName)
			except:
				fabricNames.append(Fabric.objects.get(id=fid).name)
	except:
		return HttpResponseRedirect('/viewer')

	fabricNames = ','.join(fabricNames)

	variables = {'simid': sim_id, 'productName': productName, 'fabricNames': fabricNames, 'imageUrl': imageUrl,
	             'currentUrl': request.META['HTTP_HOST']}

	return render_to_response('pages/preview.html', variables)