# -*- coding: utf-8 -*-
import json
import urllib
import imghdr

from django.contrib.auth.models import User
from django.http import HttpResponse
from django.views.decorators.csrf import csrf_exempt
from django.core.files.base import ContentFile

from PIL import Image
from cStringIO import StringIO

from fabric.models import Fabric, FabricCategory


@csrf_exempt
def texddm_image_upload(request):

    image_path =  request.GET.get('image_path')
    image_name =  request.GET.get('image_name')

    # urllib.request.urlretrieve()
    urllib.urlretrieve(image_path, image_name)

    pillow_image = Image.open(image_name)

    temp_handle = StringIO()
    pillow_image.save(temp_handle, 'PNG')
    temp_handle.seek(0)
    pillow_image = ContentFile(temp_handle.read())
    temp_handle.close()

    user = User.objects.get(username='admin')
    # ddm_category_id = 24
    ddm_category_id = 189
    category = FabricCategory.objects.get(id=ddm_category_id)
    fabric = Fabric(name='ddm', valid=True, user=user, category=category, orderValue=0)
    fabric.save()
    fabric.name = 'ddm' + str(fabric.id)

    image_filename = 'data/fabric_images/' + str(fabric.id / 10000) + '/' + str(fabric.id) + 'ddm_image.png'
    fabric.image.save(image_filename, ContentFile(pillow_image.read()))

    img = Image.open(StringIO(fabric.image.read()))

    try:
        fabric.dpi = img.info['dpi'][0]
    except KeyError:
        pass

    fabric.width, fabric.height = img.size

    THUMBNAIL_SIZE = (115, 115)
    IMAGE_TYPE = imghdr.what(fabric.image.path)

    img.thumbnail(THUMBNAIL_SIZE, Image.ANTIALIAS)
    temp_handle = StringIO()
    img.save(temp_handle, IMAGE_TYPE)
    temp_handle.seek(0)
    thumb_filename = 'data/fabric_thumbs/' + str(fabric.id / 10000) + '/' + str(fabric.id) + 'ddm_image'
    fabric.thumb.save(thumb_filename, ContentFile(temp_handle.read()))

    result = {'result': 'complete'}

    return HttpResponse(json.dumps(result), mimetype='application/json')
