# -*- coding: utf-8 -*-
import datetime
import random
import string

from django.core.mail import send_mail
from django.template import RequestContext
from django.shortcuts import render_to_response
from django.contrib.auth.models import User, Permission
from django.http import HttpResponseRedirect, HttpResponse, Http404
from django.views.decorators.csrf import csrf_exempt
from django.contrib.auth.decorators import login_required
from django.core.exceptions import ObjectDoesNotExist
from django.contrib.auth import authenticate, login, logout
from users.models import *
from fabric.models import *
from product.models import *
from django.contrib.sessions.backends.db import SessionStore
from django.contrib.sessions.models import Session
from django.contrib.sessions.middleware import SessionMiddleware
from django.template.loader import render_to_string
from django.utils.html import strip_tags

import json

## Login Form
# POST method
# Key: username, password, saveid
from mysite import settings
from mysite.fabric.models import FabricCategory
from mysite.product.models import ProductCategory


@csrf_exempt
def Login_site(request):
    if request.method == "POST":
        # if username or password is null
        if not request.POST['username'] or not request.POST['password']:
            return HttpResponseRedirect('/login_site')

        try:
            saveid = request.POST['saveid'] == 'on'
        except KeyError:
            saveid = False

        user = authenticate(username=request.POST['username'], password=request.POST['password'])

        if user is None:
            if User.objects.filter(username=request.POST['username']):
                response = {'success': False, 'reason': '密码错误'}
            else:
                response = {'success': False, 'reason': '用户名错误'}
            # Return a 'disabled account' error message
            return render_to_response('pages/errorPage.html', RequestContext(request, response))

        if not user.is_superuser:
            savedTime = user.userprofile.userDate
            nowTime = datetime.datetime.now()
            savedStartTime = user.userprofile.startDate

            if user.userprofile.valid == False:
                response = {'success': False, 'reason': '正在等待管理员的认证'}
                return render_to_response('pages/errorPage.html', RequestContext(request, response))
            if savedTime == None or savedTime.date() < nowTime.date() or savedStartTime == None or savedStartTime.date() > nowTime.date() :
                response = {'success': False, 'reason': '非使用期限'}
                return render_to_response('pages/errorPage.html', RequestContext(request, response))

        if user.is_active:
            login(request, user)
            request.session.set_expiry(datetime.timedelta(days=1))		
            sessionKey = request.session.session_key
            print('sessionKey', sessionKey)
            sessionObj = Session.objects.filter(session_key=sessionKey)
            if sessionObj.count() == 0:
                logout(request)
                response = {'success': False, 'reason': '请重新登录'}
                return render_to_response('pages/errorPage.html', RequestContext(request, response))
            else:
                userSessionObj = UserSession()
                userSessionObj.sessionKey = sessionObj[0]
                userSessionObj.userId = user		
                userSessionObj.save()
                userSessionCount = user.userprofile.sessionCount

            

            if userSessionCount is not 0:
                sessionList = Session.objects.filter(expire_date__gte=datetime.datetime.now(), usersession__userId=user).order_by('expire_date')

                if sessionList.count() > userSessionCount:
                    sessionList[1].delete()

            return HttpResponseRedirect('/viewer')
        else:
            if User.objects.filter(username=request.POST['username']) is not None:
                response = {'success': False, 'reason': 'password'}
            else:
                response = {'success': False, 'reason': 'id'}
            # Return a 'disabled account' error message
            return render_to_response('pages/errorPage.html', RequestContext(request, response))
    else:
        if request.user.is_anonymous():
            variables = {}
            return render_to_response('pages/login.html', RequestContext(request, variables))
        else:
            return HttpResponseRedirect('/viewer')

## FindUser Form
# POST method
# Key: num, company

@csrf_exempt
def findUser(request):

    findNum = request.POST['num']
    findCompany = request.POST['company']
    _LENGTH = 12  # 12자리
    # 숫자 + 대소문자
    string_pool = string.ascii_letters + string.digits

    # 랜덤한 문자열 생성
    result = ""
    for i in range(_LENGTH):
        result += random.choice(string_pool)  # 랜덤한 문자열 하나 선택

    user = User.objects.get(username=findNum, company=findCompany)
    user.set_password(result)
    user.save()
    htmlMessage = render_to_string('pages/mailForm.html', {'context': result})
    sendMessage = strip_tags(htmlMessage)
    send_mail('找回优步密码', sendMessage, 'youbu_xiangrui@163.com', [user.email], fail_silently=False)
    response = {'success': True}
    return HttpResponse(json.dumps(response))

## Login Form
# POST method
# Key: username, password, saveid
# Return: True or False
@csrf_exempt
def Login_ajax(request):
    if request.method == "POST":
        # if username or password is null
        if not request.POST['username'] or not request.POST['password']:
            response = {'success': False, 'reason': 'InsufficientParameter'}
            return HttpResponse(json.dumps(response))
        try:
            saveid = request.POST['saveid'] == 'on'
        except KeyError:
            saveid = False

        abcd = request.POST['username']
        aaaa = request.POST['password']
        print(abcd)
        print(aaaa)    
        user = authenticate(username=request.POST['username'], password=request.POST['password'])
        print(user)
        # Redirect to a success page.
        if user is None:
            response = {'success': False, 'reason': 'InvalidIdPasswd'}
            return HttpResponse(json.dumps(response))

        if not user.is_superuser:
            savedTime = user.userprofile.userDate
            nowTime = datetime.datetime.now()
            if user.userprofile.valid == False:
                response = {'success': False, 'reason': 'validFalse'}
                return HttpResponse(json.dumps(response))
            if savedTime == None or savedTime.date() < nowTime.date():
                response = {'success': False, 'reason': 'dateFalse'}
                return HttpResponse(json.dumps(response))

        if user.is_active:
            login(request, user)

            variables = {'success': True, 'id': user.id, 'permission': user.userprofile.userType}
            print(variables)
            return HttpResponse(json.dumps(variables), mimetype='application/json')
        else:
            # Return a 'disabled account' error message
            response = {'success': False, 'reason': 'InvalidIdPasswd'}
            return HttpResponse(json.dumps(response))
    else:
        raise Http404

## Logout Form
# POST method
# Return: main page path
def Logout(request):
    if request.method == "POST":
        logout(request)
        # Redirect to a success page.
        redirect_address = '/'
        if request.POST.has_key('next'):
            redirect_address = request.POST['next']
        return HttpResponseRedirect(redirect_address)
    else:
        logout(request)
        redirect_address = '/'
        if request.GET.has_key('next'):
            redirect_address = request.GET['next']
        return HttpResponseRedirect(redirect_address)

## get User list
# Return: xml - User list
def getUserList(request):
    valid = request.POST['Visible'].lower() == 'true' if request.POST.has_key('Visible') else True
    userList = User.objects.filter(userprofile__valid=valid)
    variables = {'userList': userList}
    return render_to_response('xml/userlist.xml', RequestContext(request, variables))

## getUserListByType Form
# POST method
# Key: type
def getUserListByType(request):
    type = int(request.POST['type'])
    userList=[]
    nowDate = datetime.datetime.now()

    if type == 1:
        userList = User.objects.all()
    elif type == 2:
        userProfileList = UserProfile.objects.filter(valid=True, userDate__isnull=False)
        for obj in userProfileList:
            if obj.userDate.date() > nowDate.date():
                userList.append(obj.user)
    elif type == 3:
        userProfileList = UserProfile.objects.filter(valid=False)
        for obj in userProfileList:
            userList.append(obj.user)
    elif type == 4:
        userProfileList = UserProfile.objects.filter(userDate__isnull=False)
        for obj in userProfileList:
            if obj.userDate.date() < nowDate.date():
                userList.append(obj.user)

        userProfileList = UserProfile.objects.filter(useDate_isnull=True)
        for obj in userProfileList:
            userList.append(obj.user)

    variables = {'userList': userList}
    return render_to_response('xml/userlist.xml', RequestContext(request, variables))


## Get User Info
# GET method
# Key: userId[uid]
# Return: username, profileName, userFabricCount
def getUserInfo(request):
    try:
        userId = request.POST['uid']
    except KeyError:
        raise Http404

    try:
        user = User.objects.get(id=userId)
        variables = {
            'id': userId,
            'success': True,
            'username': user.username,
            'company': user.userprofile.company,
            'companyAddress': user.userprofile.company_address,
            'wechat': user.userprofile.weChatID,
            'userFabricCount': user.userprofile.userFabricCount,
            'valid': user.userprofile.valid,
            'clientGroupId': user.userprofile.client_group.id if user.userprofile.client_group else 0,
            'sessionCount': user.userprofile.sessionCount
        }
        if user.userprofile.userDate is not None:
            variables['date'] = user.userprofile.userDate.strftime("%Y-%m-%d")
        else:
            variables['date'] = None

        if user.userprofile.startDate is not None:
            variables['startDate'] = user.userprofile.startDate.strftime("%Y-%m-%d")
        else:
            variables['startDate'] = None

        return HttpResponse(json.dumps(variables), mimetype='application/json')
    except ObjectDoesNotExist:
        variables = {'success': False, 'reason': 'DoesNotExist'}
        return HttpResponse(json.dumps(variables), mimetype='application/json')


## create User(Create or Update)
# POST method
# Key: type, userId, passwd, userName, userFabricCount
@csrf_exempt
def createUser(request):
    print('start')
    try:
        print('1try')
        username = request.POST['username']
        passwd = request.POST['passwd']
        company = request.POST['company']
        address = request.POST['address']
        email = request.POST['email']
        wechat = request.POST['wechat']
    except:
        response = {'success': False, 'reason': 'InsufficientParameter'}
        return HttpResponse(json.dumps(response), mimetype='application/json')

    # check duplicated name
    if User.objects.filter(username=username).exists():
        response = {'success': False, 'reason': 'NameAlreadyExists'}
        return HttpResponse(json.dumps(response), mimetype='application/json')

    try:
        print('2try')
        user = User.objects.create_user(username=username, password=passwd)
        user.email = email
        user.is_staff = False
        user.save()
        user.userprofile.userFabricCount = 0
        user.userprofile.company = company
        user.userprofile.company_address = address
        user.userprofile.userType = 1
        user.userprofile.client_group = None
        user.userprofile.weChatID = wechat
        user.userprofile.save()

        print('res')
        response = {'success': True, 'id': user.id}
        print('success')
        return HttpResponse(json.dumps(response), mimetype='application/json')
    except Exception as e:
        user.delete()
        response = {'success': False, 'reason': e.__class__.__name__}
        return HttpResponse(json.dumps(response), mimetype='application/json')


## modify User
# Return: json - {success: True/False}
def modifyUser(request):
    try:
        userId = int(request.POST['uid'])
        #date = request.POST['date']
        userValid = request.POST['userValid']
        userCompany = request.POST['company']
        address = request.POST['address']
        wechat = request.POST['wechat']
    except:
        raise Http404

    try:
        user = User.objects.get(id=userId)
    except ObjectDoesNotExist:
        variables = {'success': False, 'reason': 'DoesNotExist'}
        return HttpResponse(json.dumps(variables), mimetype='application/json')

    changed = False
    failReason = ''

    if request.POST.has_key('username') and request.POST['username']:
        username = request.POST['username']

        if username == user.username:
            pass
        elif User.objects.filter(username=username).exists():
            failReason += 'NameAlreadyExists;'
        else:
            user.username = username
            changed = True

    '''if request.POST.has_key('passwd') and request.POST['passwd']:
        passwd = request.POST['passwd']
        user.set_password(passwd)
        changed = True

    if request.POST.has_key('profileName') and request.POST['profileName']:
        profileName = request.POST['profileName']

        if not profileName == user.userprofile.name:
            user.userprofile.name = profileName
            changed = True'''

    if request.POST.has_key('userFabricCount') and request.POST['userFabricCount']:
        try:
            userFabricCount = int(request.POST['userFabricCount'])
        except ValueError:
            raise Http404
        if userFabricCount != user.userprofile.userFabricCount:
            userFabricCount = userFabricCount if userFabricCount > 0 else 0
            user.userprofile.userFabricCount = userFabricCount
            changed = True

    if request.POST.has_key('sessionCount') and request.POST['sessionCount']:
        try:
            sessionCount = int(request.POST['sessionCount'])
        except ValueError:
            raise Http404
        user.userprofile.sessionCount = sessionCount
        changed = True


    if userValid != user.userprofile.valid:
        if user == request.user:
            failReason += 'ItIsMyself;'
        else:
            if (userValid == 'false'):
                userValid = False
                userType = 1
            elif (userValid == 'true'):
                userValid = True
                userType = 2

                userProductCategoryCount = ProductCategory.objects.filter(user=user).count()

                if user.userprofile.userCategory == None and userProductCategoryCount == 0:
                    fabricOrderValue = FabricCategory.objects.filter(level=1).count()
                    category = FabricCategory(name=user.userprofile.company, level=1, orderValue=fabricOrderValue)
                    category.save()
                    user.userprofile.userCategory = category
                    user.userprofile.save()
                    print('userprofileSave')
                    superUser = User.objects.filter(is_superuser=True).order_by('id')[0]
                    print('-----------')
                    print(superUser)
                    print('-----------')
                    copyCategoryList = ProductCategory.objects.filter(user=superUser).order_by('id')
                    userCount = User.objects.all().count()
                    print('forStart')
                    '''
                    for obj in copyCategoryList:
                        print(obj)
                        if obj.parent:
                            parentCategoryObj = ProductCategory.objects.get(user=user, copy=obj.parent)
                            categoryObj = ProductCategory(name=obj.name, valid=True, copy=obj, orderValue=obj.orderValue, user=user, parent=parentCategoryObj)
                        else:
                            categoryObj = ProductCategory(name=user.userprofile.company, valid=True, copy=obj, orderValue=userCount, user=user)
    
                        categoryObj.save()
                    '''
                    print(copyCategoryList.count())
                    i = 1
                    for obj in copyCategoryList:
                        print('forororororor')
                        print(obj.id)
                        print(i)
                        i = i + 1
                        if obj.parent:
                            parentCategoryObj = ProductCategory.objects.get(user=user, copy=obj.parent)
                            categoryObj = ProductCategory(name=obj.name, valid=True, copy=obj, orderValue=obj.orderValue, user=user, parent=parentCategoryObj)
                        else:
                            categoryObj = ProductCategory(name=user.userprofile.company, valid=True, copy=obj, orderValue=userCount, user=user)
                        print('asdasd')
                        categoryObj.save()
                        print('asdasdqqqq223')
            else:
                failReason += 'valid is not correct'
            user.userprofile.valid = userValid
            user.userprofile.userType = userType
            changed = True

    '''if date != 'null':
        savedDate = user.userprofile.userDate
        nowDate = datetime.datetime.now()
        if savedDate == None or savedDate.date() < nowDate.date():
            if date == '1':
                newDate = nowDate + datetime.timedelta(days=7)
            elif date == '2':
                newDate = nowDate + datetime.timedelta(days=365)
            else:
                failReason += 'dateError'
        else:
            if date == '1':
                newDate = savedDate + datetime.timedelta(days=7)
            elif date == '2':
                newDate = savedDate + datetime.timedelta(days=365)
            else:
                failReason += 'dateError'

        user.userprofile.userDate = newDate'''

    if request.POST.has_key('startDate') and request.POST['startDate']:
        try:
            startDate = request.POST['startDate']
        except ValueError:
            raise Http404
        savedData = user.userprofile.startDate
        startDateTimeStamp = datetime.datetime.strptime(startDate, "%Y-%m-%d")
        if savedData != startDateTimeStamp:
            user.userprofile.startDate = startDateTimeStamp
            changed = True

    if request.POST.has_key('endDate') and request.POST['endDate']:
        try:
            endDate = request.POST['endDate']
        except ValueError:
            raise Http404
        savedData = user.userprofile.userDate
        endDateTimeStamp = datetime.datetime.strptime(endDate + ':23:59:59', "%Y-%m-%d:%H:%M:%S")
        if savedData != endDateTimeStamp:
            user.userprofile.userDate = endDateTimeStamp
            changed = True

    if userCompany != 'null':
        savedData = user.userprofile.company
        if userCompany != savedData:
            user.userprofile.company = userCompany
            changed = True

    if address != 'null':
        savedData = user.userprofile.company_address
        if address != savedData:
            user.userprofile.company_address = address
            changed = True

    if wechat != 'null':
        savedData = user.userprofile.weChatID
        if wechat != savedData:
            user.userprofile.weChatID = wechat
            changed = True

    if len(failReason) > 0:
        variables = {'success': False, 'reason': failReason}
        return HttpResponse(json.dumps(variables), mimetype='application/json')

    if changed:
        user.userprofile.save()
        user.save()
        variables = {'success': True, 'userId': user.id}
        return HttpResponse(json.dumps(variables), mimetype='application/json')
    else:
        variables = {'success': False, 'reason': 'NoChanges'}
        return HttpResponse(json.dumps(variables), mimetype='application/json')


## delete User
# POST method
# Key: userId[uid]
# delete User and Fabric, Files for User
def deleteUser(request):
    try:
        userId = int(request.POST['uid'])
    except:
        raise Http404

    try:
        user = User.objects.get(id=userId)
    except ObjectDoesNotExist:
        variables = {'success': False, 'reason': 'DoesNotExist'}
        return HttpResponse(json.dumps(variables), mimetype='application/json')

    if user == request.user:
        variables = {'success': False, 'reason': 'ItIsMyself'}
        return HttpResponse(json.dumps(variables), mimetype='application/json')

    user.userprofile.userCategory.delete()
    userProductCategoryList = ProductCategory.objects.filter(user=user)
    user.delete()
    variables = {'success': True}
    return HttpResponse(json.dumps(variables), mimetype='application/json')


def getClientGroupList(request):
    clientGroupList = ClientGroup.objects.all()
    variables = {'clientGroupList': clientGroupList}
    return render_to_response('xml/clientgrouplist.xml', RequestContext(request, variables))


def createClientGroup(request):
    try:
        name = request.POST['name']
        if not name:
            raise Exception
    except:
        response = {'success': False, 'reason': 'InsufficientParameter'}
        return HttpResponse(json.dumps(response), mimetype='application/json')

    # check duplicated name
    if ClientGroup.objects.filter(name=name).exists():
        response = {'success': False, 'reason': 'NameAlreadyExists'}
        return HttpResponse(json.dumps(response), mimetype='application/json')

    try:
        clientGroup = ClientGroup(name=name)
        clientGroup.save()
        response = {'success': True, 'id': clientGroup.id}
        return HttpResponse(json.dumps(response), mimetype='application/json')
    except Exception as e:
        clientGroup.delete()
        response = {'success': False, 'reason': e.__class__.__name__}
        return HttpResponse(json.dumps(response), mimetype='application/json')

@login_required()
def myPage(request):
    return render_to_response('pages/myPage.html', RequestContext(request))

## modifyUserPassword
# POST method
# Key: nowPW, newPW
def modifyUserPassword(request):
    nowPW = request.POST['nowPW']
    newPW = request.POST['newPW']
    user = request.user

    if user.check_password(nowPW):
        user.set_password(newPW)
        user.save()
        user = authenticate(username=user.username, password=newPW)

        if user is not None:
            login(request, user)
            variable = {'success': True}
        else:
            variable = {'success': False, 'reason': 'relogin'}
    else:
        variable = {'success': False, 'reason': '请确认当前密码'}

    return HttpResponse(json.dumps(variable), mimetype='application/json')


def modifyClientGroup(request):
    try:
        clientGroupId = int(request.POST['cgid'])
        name = request.POST['name']
        if not name:
            raise Exception
    except:
        raise Http404

    try:
        clientGroup = ClientGroup.objects.get(id=clientGroupId)
    except ObjectDoesNotExist:
        variables = {'success': False, 'reason': 'DoesNotExist'}
        return HttpResponse(json.dumps(variables), mimetype='application/json')

    if clientGroup.name != name:
        clientGroup.name = name
        clientGroup.save()

        variables = {'success': True}
        return HttpResponse(json.dumps(variables), mimetype='application/json')
    else:
        variables = {'success': False, 'reason': 'NoChanges'}
        return HttpResponse(json.dumps(variables), mimetype='application/json')


def deleteClientGroup(request):
    try:
        clientGroupId = int(request.POST['cgid'])
    except:
        raise Http404

    try:
        clientGroup = ClientGroup.objects.get(id=clientGroupId)
    except ObjectDoesNotExist:
        variables = {'success': False, 'reason': 'DoesNotExist'}
        return HttpResponse(json.dumps(variables), mimetype='application/json')

    if clientGroup.userprofile_set.exists():
        variables = {'success': False, 'reason': 'HasUserSet'}
        return HttpResponse(json.dumps(variables), mimetype='application/json')

    clientGroup.delete()

    variables = {'success': True}
    return HttpResponse(json.dumps(variables), mimetype='application/json')

## getUserListAllType
# POST method
# Key: None
def getUserListAllType(request):
    userList1 = []
    userList2 = []
    userList3 = []

    nowDate = datetime.datetime.now()

    userProfileList = UserProfile.objects.filter(valid=True, user__is_superuser=False).order_by('id')
    for obj in userProfileList:
        userObj = {'id':obj.user.id, 'company':obj.company, 'name': obj.user.username}
        if obj.userDate is None or obj.userDate.date() <= nowDate.date() :
            userList3.append(userObj)
        else:
            userList1.append(userObj)

    userProfileList = UserProfile.objects.filter(valid=False, user__is_superuser=False).order_by('id')
    for obj in userProfileList:
        userObj = {'id': obj.user.id, 'company': obj.company, 'name': obj.user.username}
        userList2.append(userObj)

    variables = {'userList1': userList1, 'userList2': userList2, 'userList3': userList3}
    return HttpResponse(json.dumps(variables), mimetype='application/json')

## getUserListByAddress
# POST method
# Key: address
def getUserListByAddress(request):
    address = request.POST['address']
    userProfileList = UserProfile.objects.filter(company_address__icontains=address)
    userList = []

    for obj in userProfileList:
        userObj = {'id': obj.user.id, 'company': obj.company, 'name': obj.user.username}
        userList.append(userObj)

    return HttpResponse(json.dumps(userList), mimetype='application/json')